/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mobicents.media.server.mgcp.controller.signal.MgcpPackage;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageFactory {
    private HashMap<String, PackageDescriptor> packages = new HashMap();

    public PackageFactory(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName() == null || !list.item(i).getNodeName().equalsIgnoreCase("package")) continue;
            this.loadPackage(list.item(i));
        }
    }

    private void loadPackage(Node descriptor) {
        NamedNodeMap attributes = descriptor.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        PackageDescriptor pkg = new PackageDescriptor(name);
        NodeList list = descriptor.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!list.item(i).getNodeName().equals("signal")) continue;
            this.createExecutor(pkg, list.item(i));
        }
        this.packages.put(name, pkg);
    }

    private void createExecutor(PackageDescriptor pkg, Node descriptor) {
        NamedNodeMap attributes = descriptor.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        String className = attributes.getNamedItem("handler").getNodeValue();
        ExecutorDescriptor executor = new ExecutorDescriptor(name, className);
        pkg.add(executor);
    }

    public MgcpPackage getPackage(String name) throws Exception {
        PackageDescriptor descriptor = this.packages.get(name);
        return descriptor != null ? descriptor.getPackage() : null;
    }

    private class ExecutorDescriptor {
        private String name;
        private String className;

        public ExecutorDescriptor(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public Signal load() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Constructor<?>[] constructors;
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> def = loader.loadClass(this.className);
            Constructor<?> constructor = null;
            for (Constructor<?> cons : constructors = def.getConstructors()) {
                Class<?>[] paramTypes = cons.getParameterTypes();
                if (paramTypes.length != 1 || paramTypes[0] != String.class) continue;
                constructor = cons;
                break;
            }
            if (constructor == null) {
                throw new InstantiationException("Signal must have constructor with string name");
            }
            Signal s = (Signal)constructor.newInstance(this.name);
            return s;
        }
    }

    private class PackageDescriptor {
        private String name;
        private ArrayList<ExecutorDescriptor> descriptors = new ArrayList();

        public PackageDescriptor(String name) {
            this.name = name;
        }

        public void add(ExecutorDescriptor descriptor) {
            this.descriptors.add(descriptor);
        }

        public MgcpPackage getPackage() throws Exception {
            ArrayList<Signal> signals = new ArrayList<Signal>();
            for (ExecutorDescriptor descriptor : this.descriptors) {
                signals.add(descriptor.load());
            }
            return new MgcpPackage(this.name, signals);
        }
    }
}

