/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.command;

import com.google.common.base.Optional;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.AbstractMgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandException;
import org.mobicents.media.control.mgcp.command.MgcpCommandResult;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.util.collections.Parameters;
import org.mobicents.media.server.spi.ConnectionMode;

public class ModifyConnectionCommand
extends AbstractMgcpCommand {
    private static final Logger log = Logger.getLogger(ModifyConnectionCommand.class);

    public ModifyConnectionCommand(int transactionId, Parameters<MgcpParameterType> parameters, MgcpEndpointManager endpointManager) {
        super(transactionId, parameters, endpointManager);
    }

    private void validateParameters(Parameters<MgcpParameterType> parameters, MdcxContext context) throws MgcpCommandException, RuntimeException {
        Optional<Integer> callId = parameters.getIntegerBase16(MgcpParameterType.CALL_ID);
        if (!callId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.INCORRECT_CALL_ID);
        }
        context.callId = (Integer)callId.get();
        Optional<String> endpointId = parameters.getString(MgcpParameterType.ENDPOINT_ID);
        if (!endpointId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        if (((String)endpointId.get()).contains("*") || ((String)endpointId.get()).contains("$")) {
            throw new MgcpCommandException(MgcpResponseCode.WILDCARD_TOO_COMPLICATED);
        }
        context.endpointId = (String)endpointId.get();
        Optional<Integer> connectionId = parameters.getIntegerBase16(MgcpParameterType.CONNECTION_ID);
        if (!connectionId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.INCORRECT_CONNECTION_ID);
        }
        context.connectionId = (Integer)connectionId.get();
        Optional<String> mode = parameters.getString(MgcpParameterType.MODE);
        if (mode.isPresent()) {
            try {
                ConnectionMode connectionMode = ConnectionMode.fromDescription((String)((String)mode.get()));
                context.mode = connectionMode;
            }
            catch (IllegalArgumentException e) {
                throw new MgcpCommandException(MgcpResponseCode.INVALID_OR_UNSUPPORTED_MODE);
            }
        }
        context.remoteDescription = (String)parameters.getString(MgcpParameterType.SDP).or((Object)"");
    }

    private void executeCommand(MdcxContext context) throws MgcpCommandException {
        String remoteSdp;
        int connectionId;
        String endpointId = context.endpointId;
        MgcpEndpoint endpoint = this.endpointManager.getEndpoint(endpointId);
        if (endpoint == null) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        int callId = context.callId;
        MgcpConnection connection = endpoint.getConnection(callId, connectionId = context.connectionId);
        if (connection == null) {
            throw new MgcpCommandException(MgcpResponseCode.INCORRECT_CONNECTION_ID);
        }
        ConnectionMode mode = context.mode;
        if (mode != null) {
            connection.setMode(mode);
        }
        if (!(remoteSdp = context.remoteDescription).isEmpty()) {
            try {
                String localSdp = connection.open(remoteSdp);
                context.localDescription = localSdp;
            }
            catch (MgcpConnectionException e) {
                throw new MgcpCommandException(MgcpResponseCode.UNSUPPORTED_SDP);
            }
        }
    }

    private MgcpCommandResult respond(MdcxContext context) {
        boolean successful;
        Parameters<MgcpParameterType> parameters = new Parameters<MgcpParameterType>();
        MgcpCommandResult result = new MgcpCommandResult(this.transactionId, context.code, context.message, parameters);
        boolean bl = successful = context.code < 300;
        if (successful) {
            this.translateContext(context, parameters);
        }
        return result;
    }

    private void translateContext(MdcxContext context, Parameters<MgcpParameterType> parameters) {
        String localDescription = context.localDescription;
        if (!localDescription.isEmpty()) {
            parameters.put(MgcpParameterType.SDP, localDescription);
        }
    }

    @Override
    public MgcpCommandResult call() {
        MdcxContext context = new MdcxContext();
        try {
            this.validateParameters(this.requestParameters, context);
            this.executeCommand(context);
            context.code = MgcpResponseCode.TRANSACTION_WAS_EXECUTED.code();
            context.message = MgcpResponseCode.TRANSACTION_WAS_EXECUTED.message();
        }
        catch (RuntimeException e) {
            log.error((Object)("Unexpected error occurred during tx=" + this.transactionId + " execution. Rolling back."));
            context.code = MgcpResponseCode.PROTOCOL_ERROR.code();
            context.message = MgcpResponseCode.PROTOCOL_ERROR.message();
        }
        catch (MgcpCommandException e) {
            log.error((Object)("Protocol error occurred during tx=" + this.transactionId + " execution: " + e.getMessage()));
            context.code = e.getCode();
            context.message = e.getMessage();
        }
        return this.respond(context);
    }

    private class MdcxContext {
        private int callId = -1;
        private String endpointId = "";
        private int connectionId = -1;
        private ConnectionMode mode = null;
        private String remoteDescription = "";
        private String localDescription = "";
        private int code = MgcpResponseCode.ABORTED.code();
        private String message = MgcpResponseCode.ABORTED.message();
    }
}

