/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.command;

import com.google.common.base.Optional;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.AbstractMgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandException;
import org.mobicents.media.control.mgcp.command.MgcpCommandResult;
import org.mobicents.media.control.mgcp.command.NotificationRequest;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.exception.MgcpParseException;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEventsParser;
import org.mobicents.media.control.mgcp.pkg.MgcpSignal;
import org.mobicents.media.control.mgcp.pkg.MgcpSignalProvider;
import org.mobicents.media.control.mgcp.pkg.NotifiedEntityParser;
import org.mobicents.media.control.mgcp.pkg.SignalRequest;
import org.mobicents.media.control.mgcp.pkg.SignalsRequestParser;
import org.mobicents.media.control.mgcp.pkg.exception.UnrecognizedMgcpActionException;
import org.mobicents.media.control.mgcp.pkg.exception.UnrecognizedMgcpEventException;
import org.mobicents.media.control.mgcp.pkg.exception.UnrecognizedMgcpPackageException;
import org.mobicents.media.control.mgcp.pkg.exception.UnsupportedMgcpSignalException;
import org.mobicents.media.control.mgcp.util.collections.Parameters;

public class RequestNotificationCommand
extends AbstractMgcpCommand {
    private static final Logger log = Logger.getLogger(RequestNotificationCommand.class);
    private final MgcpSignalProvider signalProvider;

    public RequestNotificationCommand(int transactionId, Parameters<MgcpParameterType> parameters, MgcpEndpointManager endpointManager, MgcpSignalProvider signalProvider) {
        super(transactionId, parameters, endpointManager);
        this.signalProvider = signalProvider;
    }

    private void validateParameters(Parameters<MgcpParameterType> parameters, RqntContext context) throws MgcpCommandException, RuntimeException {
        Optional<String> callAgent;
        Optional<String> events;
        Optional<String> endpointId = parameters.getString(MgcpParameterType.ENDPOINT_ID);
        if (!endpointId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        if (((String)endpointId.get()).contains("$")) {
            throw new MgcpCommandException(MgcpResponseCode.WILDCARD_TOO_COMPLICATED);
        }
        context.endpointId = (String)endpointId.get();
        Optional<String> requestId = this.requestParameters.getString(MgcpParameterType.REQUEST_ID);
        if (!requestId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.PROTOCOL_ERROR);
        }
        context.requestId = (String)requestId.get();
        Optional<String> requestedSignals = this.requestParameters.getString(MgcpParameterType.REQUESTED_SIGNALS);
        if (requestedSignals.isPresent()) {
            try {
                SignalRequest[] signalRequests = SignalsRequestParser.parse((String)requestedSignals.get());
                RqntContext.access$202(context, signalRequests);
            }
            catch (MgcpParseException e) {
                throw new MgcpCommandException(MgcpResponseCode.PROTOCOL_ERROR);
            }
        }
        if ((events = this.requestParameters.getString(MgcpParameterType.REQUESTED_EVENTS)).isPresent()) {
            try {
                MgcpRequestedEvent[] requestedEvents = MgcpRequestedEventsParser.parse((String)events.get());
                RqntContext.access$302(context, requestedEvents);
            }
            catch (UnrecognizedMgcpPackageException e) {
                throw new MgcpCommandException(MgcpResponseCode.UNKNOWN_PACKAGE);
            }
            catch (UnrecognizedMgcpEventException e) {
                throw new MgcpCommandException(MgcpResponseCode.NO_SUCH_EVENT_OR_SIGNAL);
            }
            catch (UnrecognizedMgcpActionException e) {
                throw new MgcpCommandException(MgcpResponseCode.EVENT_OR_SIGNAL_PARAMETER_ERROR);
            }
            catch (MgcpParseException e) {
                throw new MgcpCommandException(MgcpResponseCode.PROTOCOL_ERROR);
            }
        }
        if ((callAgent = this.requestParameters.getString(MgcpParameterType.NOTIFIED_ENTITY)).isPresent()) {
            try {
                NotifiedEntity notifiedEntity = NotifiedEntityParser.parse((String)callAgent.get());
                context.notifiedEntity = notifiedEntity;
            }
            catch (ParseException e) {
                throw new MgcpCommandException(MgcpResponseCode.PROTOCOL_ERROR);
            }
        }
    }

    private void executeCommand(RqntContext context) throws MgcpCommandException {
        MgcpEndpoint endpoint = this.endpointManager.getEndpoint(context.endpointId);
        if (endpoint == null) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        SignalRequest[] signalRequests = context.signalRequests;
        MgcpSignal[] signals = new MgcpSignal[]{};
        if (signalRequests.length > 0) {
            try {
                signals = new MgcpSignal[signalRequests.length];
                for (int i = 0; i < signalRequests.length; ++i) {
                    SignalRequest signalRequest = signalRequests[i];
                    signals[i] = this.signalProvider.provide(signalRequest.getPackageName(), signalRequest.getSignalType(), Integer.parseInt(context.requestId, 16), signalRequest.getParameters(), endpoint);
                }
            }
            catch (UnrecognizedMgcpPackageException e) {
                throw new MgcpCommandException(MgcpResponseCode.UNKNOWN_PACKAGE);
            }
            catch (UnsupportedMgcpSignalException e) {
                throw new MgcpCommandException(MgcpResponseCode.NO_SUCH_EVENT_OR_SIGNAL);
            }
        }
        NotificationRequest rqnt = new NotificationRequest(this.transactionId, context.requestId, context.notifiedEntity, context.requestedEvents, signals);
        endpoint.requestNotification(rqnt);
    }

    private MgcpCommandResult respond(RqntContext context) {
        Parameters<MgcpParameterType> parameters = new Parameters<MgcpParameterType>();
        MgcpCommandResult result = new MgcpCommandResult(this.transactionId, context.code, context.message, parameters);
        return result;
    }

    @Override
    public MgcpCommandResult call() {
        RqntContext context = new RqntContext();
        try {
            this.validateParameters(this.requestParameters, context);
            this.executeCommand(context);
            context.code = MgcpResponseCode.TRANSACTION_WAS_EXECUTED.code();
            context.message = MgcpResponseCode.TRANSACTION_WAS_EXECUTED.message();
        }
        catch (RuntimeException e) {
            log.error((Object)("Unexpected error occurred during tx=" + this.transactionId + " execution. Rolling back."));
            context.code = MgcpResponseCode.PROTOCOL_ERROR.code();
            context.message = MgcpResponseCode.PROTOCOL_ERROR.message();
        }
        catch (MgcpCommandException e) {
            log.error((Object)("Protocol error occurred during tx=" + this.transactionId + " execution: " + e.getMessage()));
            context.code = e.getCode();
            context.message = e.getMessage();
        }
        return this.respond(context);
    }

    private class RqntContext {
        private String endpointId = "";
        private String requestId = "";
        private SignalRequest[] signalRequests = new SignalRequest[0];
        private MgcpRequestedEvent[] requestedEvents = new MgcpRequestedEvent[0];
        private NotifiedEntity notifiedEntity = null;
        private int code = MgcpResponseCode.ABORTED.code();
        private String message = MgcpResponseCode.ABORTED.message();

        static /* synthetic */ SignalRequest[] access$202(RqntContext x0, SignalRequest[] x1) {
            x0.signalRequests = x1;
            return x1;
        }

        static /* synthetic */ MgcpRequestedEvent[] access$302(RqntContext x0, MgcpRequestedEvent[] x1) {
            x0.requestedEvents = x1;
            return x1;
        }
    }
}

