/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;

public class MgcpCall {
    private static final Logger log = Logger.getLogger(MgcpCall.class);
    private final int id;
    private ConcurrentHashMap<Integer, MgcpConnection> connections;

    public MgcpCall(int id) {
        this.id = id;
        this.connections = new ConcurrentHashMap(6);
    }

    public int getId() {
        return this.id;
    }

    public boolean hasConnections() {
        return !this.connections.isEmpty();
    }

    public int countConnections() {
        return this.connections.size();
    }

    public MgcpConnection getConnection(int connectionId) {
        return this.connections.get(connectionId);
    }

    public void addConnection(MgcpConnection connection) throws IllegalArgumentException {
        int connectionId = connection.getIdentifier();
        MgcpConnection oldConnection = this.connections.putIfAbsent(connectionId, connection);
        if (oldConnection != null) {
            throw new IllegalArgumentException("Conection " + connectionId + " is already registered in call " + this.id);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered connection " + connectionId + " to call " + this.id));
        }
    }

    public MgcpConnection removeConnection(int connectionId) {
        MgcpConnection connection = this.connections.remove(connectionId);
        if (log.isDebugEnabled() && connection != null) {
            log.debug((Object)("Unregistered connection " + connectionId + " from call " + this.id));
        }
        return connection;
    }

    public List<MgcpConnection> removeConnections() {
        ArrayList<MgcpConnection> values = new ArrayList<MgcpConnection>(this.connections.values());
        this.connections.clear();
        return values;
    }
}

