/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.endpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.NotificationRequest;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;
import org.mobicents.media.control.mgcp.connection.AbstractMgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpCall;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionProvider;
import org.mobicents.media.control.mgcp.connection.MgcpRemoteConnection;
import org.mobicents.media.control.mgcp.endpoint.EndpointIdentifier;
import org.mobicents.media.control.mgcp.endpoint.MediaGroup;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointObserver;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointState;
import org.mobicents.media.control.mgcp.exception.MgcpCallNotFoundException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionNotFound;
import org.mobicents.media.control.mgcp.listener.MgcpCallListener;
import org.mobicents.media.control.mgcp.listener.MgcpConnectionListener;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpRequestType;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpSignal;
import org.mobicents.media.control.mgcp.pkg.SignalType;

public class GenericMgcpEndpoint
implements MgcpEndpoint,
MgcpCallListener,
MgcpConnectionListener {
    private static final Logger log = Logger.getLogger(GenericMgcpEndpoint.class);
    private final MgcpConnectionProvider connectionProvider;
    protected final MediaGroup mediaGroup;
    private final EndpointIdentifier endpointId;
    private final ConcurrentHashMap<Integer, MgcpCall> calls;
    private final AtomicBoolean active;
    private NotifiedEntity notifiedEntity;
    private ConcurrentHashMap<String, MgcpSignal> signals;
    private MgcpRequestedEvent[] requestedEvents;
    private final Collection<MgcpEndpointObserver> endpointObservers;
    private final Collection<MgcpMessageObserver> messageObservers;

    public GenericMgcpEndpoint(EndpointIdentifier endpointId, MgcpConnectionProvider connectionProvider, MediaGroup mediaGroup) {
        this.connectionProvider = connectionProvider;
        this.endpointId = endpointId;
        this.calls = new ConcurrentHashMap(10);
        this.active = new AtomicBoolean(false);
        this.mediaGroup = mediaGroup;
        this.notifiedEntity = new NotifiedEntity();
        this.signals = new ConcurrentHashMap(5);
        this.endpointObservers = new CopyOnWriteArrayList<MgcpEndpointObserver>();
        this.messageObservers = new CopyOnWriteArrayList<MgcpMessageObserver>();
    }

    @Override
    public EndpointIdentifier getEndpointId() {
        return this.endpointId;
    }

    @Override
    public MediaGroup getMediaGroup() {
        return this.mediaGroup;
    }

    public boolean hasCalls() {
        return !this.calls.isEmpty();
    }

    @Override
    public MgcpConnection getConnection(int callId, int connectionId) {
        MgcpCall call = this.calls.get(callId);
        return call == null ? null : call.getConnection(connectionId);
    }

    private void registerConnection(int callId, MgcpConnection connection) {
        MgcpCall call = this.calls.get(callId);
        if (call == null) {
            call = new MgcpCall(callId);
            MgcpCall oldCall = this.calls.putIfAbsent(callId, call);
            if (oldCall != null) {
                call = oldCall;
            }
        }
        call.addConnection(connection);
        this.onConnectionCreated(connection);
        if (!this.isActive()) {
            this.activate();
        }
    }

    @Override
    public MgcpConnection createConnection(int callId, boolean local) {
        AbstractMgcpConnection connection = local ? this.connectionProvider.provideLocal() : this.connectionProvider.provideRemote();
        this.registerConnection(callId, connection);
        if (!connection.isLocal()) {
            ((MgcpRemoteConnection)connection).setConnectionListener(this);
        }
        return connection;
    }

    @Override
    public MgcpConnection deleteConnection(int callId, int connectionId) throws MgcpCallNotFoundException, MgcpConnectionNotFound {
        MgcpCall call = this.calls.get(callId);
        if (call == null) {
            throw new MgcpCallNotFoundException("Call " + callId + " was not found.");
        }
        MgcpConnection connection = call.removeConnection(connectionId);
        if (connection == null) {
            throw new MgcpConnectionNotFound("Connection " + Integer.toHexString(connectionId) + " was not found in call " + callId);
        }
        if (!call.hasConnections()) {
            this.calls.remove(callId);
        }
        this.onConnectionDeleted(connection);
        if (!this.hasCalls()) {
            this.deactivate();
        }
        try {
            connection.close();
        }
        catch (MgcpConnectionException e) {
            log.error((Object)(this.endpointId + ": Connection " + connection.getHexIdentifier() + " was not closed properly"), (Throwable)e);
        }
        return connection;
    }

    private List<MgcpConnection> deleteConnections(MgcpCall call) {
        List<MgcpConnection> connections = call.removeConnections();
        for (MgcpConnection connection : connections) {
            try {
                connection.close();
            }
            catch (MgcpConnectionException e) {
                log.error((Object)(this.endpointId + ": Connection " + connection.getHexIdentifier() + " was not closed properly"), (Throwable)e);
            }
        }
        return connections;
    }

    @Override
    public List<MgcpConnection> deleteConnections(int callId) throws MgcpCallNotFoundException {
        MgcpCall call = this.calls.remove(callId);
        if (call == null) {
            throw new MgcpCallNotFoundException("Call " + callId + " was not found.");
        }
        List<MgcpConnection> connections = this.deleteConnections(call);
        if (!this.hasCalls()) {
            this.deactivate();
        }
        return connections;
    }

    @Override
    public List<MgcpConnection> deleteConnections() {
        ArrayList<MgcpConnection> connections = new ArrayList<MgcpConnection>();
        Iterator<MgcpCall> iterator = this.calls.values().iterator();
        while (iterator.hasNext()) {
            MgcpCall call = iterator.next();
            iterator.remove();
            connections.addAll(this.deleteConnections(call));
        }
        if (!this.hasCalls()) {
            this.deactivate();
        }
        return connections;
    }

    @Override
    public void onCallTerminated(MgcpCall call) {
        this.calls.remove(call.getId());
    }

    public boolean isActive() {
        return this.active.get();
    }

    private void activate() throws IllegalStateException {
        if (this.active.get()) {
            throw new IllegalArgumentException("Endpoint " + this.endpointId + " is already active.");
        }
        this.active.set(true);
        this.onActivated();
        this.notify(this, MgcpEndpointState.ACTIVE);
    }

    protected void deactivate() throws IllegalStateException {
        if (!this.active.get()) {
            throw new IllegalArgumentException("Endpoint " + this.endpointId + " is already inactive.");
        }
        this.active.set(false);
        this.onDeactivated();
        this.notify(this, MgcpEndpointState.INACTIVE);
    }

    @Override
    public void onConnectionFailure(MgcpConnection connection) {
        Iterator<MgcpCall> iterator = this.calls.values().iterator();
        while (iterator.hasNext()) {
            MgcpCall call = iterator.next();
            MgcpConnection removed = call.removeConnection(connection.getIdentifier());
            if (removed == null) continue;
            if (!call.hasConnections()) {
                iterator.remove();
            }
            this.onConnectionDeleted(connection);
            if (this.hasCalls()) continue;
            this.deactivate();
        }
    }

    @Override
    public synchronized void requestNotification(NotificationRequest request) {
        if (request.getNotifiedEntity() != null) {
            this.notifiedEntity = request.getNotifiedEntity();
        }
        this.requestedEvents = request.getRequestedEvents();
        if (request.countSignals() == 0) {
            Iterator keys = this.signals.keySet().iterator();
            while (keys.hasNext()) {
                MgcpSignal ongoing = this.signals.get(keys.next());
                if (ongoing == null) continue;
                ongoing.cancel();
            }
        } else {
            ArrayList<String> retained = new ArrayList<String>(request.countSignals());
            MgcpSignal signal = request.pollSignal();
            while (signal != null) {
                SignalType signalType = signal.getSignalType();
                switch (signalType) {
                    case TIME_OUT: {
                        String signalName = signal.getName();
                        retained.add(signalName);
                        MgcpSignal original = this.signals.putIfAbsent(signalName, signal);
                        if (original != null) break;
                        signal.observe(this);
                        signal.execute();
                        break;
                    }
                    case BRIEF: {
                        signal.execute();
                        break;
                    }
                    default: {
                        log.warn((Object)("Dropping signal " + signal.toString() + " on endpoint " + this.getEndpointId().toString() + " because signal type " + (Object)((Object)signalType) + "is not supported."));
                    }
                }
                signal = request.pollSignal();
            }
            for (String key : this.signals.keySet()) {
                if (retained.contains(key)) continue;
                this.cancelSignal(key);
            }
        }
    }

    @Override
    public void cancelSignal(String signal) {
        MgcpSignal ongoing = this.signals.get(signal);
        if (ongoing != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Canceling signal " + ongoing.toString() + " on endpoint " + this.getEndpointId().toString()));
            }
            ongoing.cancel();
        }
    }

    protected void onConnectionCreated(MgcpConnection connection) {
    }

    protected void onConnectionDeleted(MgcpConnection connection) {
    }

    protected void onActivated() {
    }

    protected void onDeactivated() {
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.messageObservers.add(observer);
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.messageObservers.remove(observer);
    }

    @Override
    public void notify(Object originator, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.messageObservers) {
            if (observer == originator) continue;
            observer.onMessage(message, direction);
        }
    }

    @Override
    public void onEvent(Object originator, MgcpEvent event) {
        String composedName = event.getPackage() + "/" + event.getSymbol();
        if (this.isListening(composedName) && originator instanceof MgcpSignal) {
            MgcpSignal signal = (MgcpSignal)originator;
            this.signals.remove(signal.getName());
            MgcpRequest notify = new MgcpRequest();
            notify.setRequestType(MgcpRequestType.NTFY);
            notify.setTransactionId(0);
            notify.setEndpointId(this.endpointId.toString());
            notify.addParameter(MgcpParameterType.NOTIFIED_ENTITY, this.notifiedEntity.toString());
            notify.addParameter(MgcpParameterType.OBSERVED_EVENT, event.toString());
            notify.addParameter(MgcpParameterType.REQUEST_ID, Integer.toString(signal.getRequestId(), 16));
            this.notify(this, notify, MessageDirection.OUTGOING);
        }
    }

    @Override
    public void observe(MgcpEndpointObserver observer) {
        this.endpointObservers.add(observer);
    }

    @Override
    public void forget(MgcpEndpointObserver observer) {
        this.endpointObservers.remove(observer);
    }

    @Override
    public void notify(MgcpEndpoint endpoint, MgcpEndpointState state) {
        for (MgcpEndpointObserver observer : this.endpointObservers) {
            observer.onEndpointStateChanged(this, state);
        }
    }

    private boolean isListening(String event) {
        for (MgcpRequestedEvent evt : this.requestedEvents) {
            if (!evt.getQualifiedName().equalsIgnoreCase(event)) continue;
            return true;
        }
        return false;
    }
}

