/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.endpoint;

import org.mobicents.media.control.mgcp.endpoint.MediaGroup;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.resource.audio.AudioRecorderImpl;
import org.mobicents.media.server.impl.resource.dtmf.DetectorImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.AudioPlayerImpl;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorProvider;
import org.mobicents.media.server.spi.dtmf.DtmfGenerator;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerProvider;
import org.mobicents.media.server.spi.recorder.Recorder;
import org.mobicents.media.server.spi.recorder.RecorderProvider;

public class MediaGroupImpl
implements MediaGroup {
    private final AudioComponent audioComponent;
    private final OOBComponent oobComponent;
    private final Player player;
    private final Recorder recorder;
    private final DtmfDetector detector;
    private final DtmfGenerator generator;

    public MediaGroupImpl(AudioComponent audioComponent, OOBComponent oobComponent, PlayerProvider players, RecorderProvider recorders, DtmfDetectorProvider detectors) {
        this.audioComponent = audioComponent;
        this.oobComponent = oobComponent;
        this.player = this.initializePlayer(players);
        this.recorder = this.initializeRecorder(recorders);
        this.detector = this.initializeDetector(detectors);
        this.generator = null;
    }

    private Player initializePlayer(PlayerProvider players) {
        AudioPlayerImpl player = (AudioPlayerImpl)players.provide();
        this.audioComponent.addInput(player.getAudioInput());
        this.audioComponent.updateMode(true, false);
        return player;
    }

    private DtmfDetector initializeDetector(DtmfDetectorProvider detectors) {
        DetectorImpl detector = (DetectorImpl)detectors.provide();
        this.audioComponent.addOutput(detector.getAudioOutput());
        this.oobComponent.addOutput(detector.getOOBOutput());
        this.audioComponent.updateMode(true, true);
        this.oobComponent.updateMode(true, true);
        return detector;
    }

    private Recorder initializeRecorder(RecorderProvider recorders) {
        AudioRecorderImpl recorder = (AudioRecorderImpl)recorders.provide();
        this.audioComponent.addOutput(recorder.getAudioOutput());
        this.oobComponent.addOutput(recorder.getOOBOutput());
        this.audioComponent.updateMode(false, true);
        this.oobComponent.updateMode(false, true);
        return recorder;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Recorder getRecorder() {
        return this.recorder;
    }

    @Override
    public DtmfDetector getDetector() {
        return this.detector;
    }

    @Override
    public DtmfGenerator getGenerator() {
        return this.generator;
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBComponent getOobComponent() {
        return this.oobComponent;
    }
}

