/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.endpoint;

import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionProvider;
import org.mobicents.media.control.mgcp.endpoint.EndpointIdentifier;
import org.mobicents.media.control.mgcp.endpoint.GenericMgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MediaGroup;
import org.mobicents.media.control.mgcp.endpoint.MediaGroupImpl;
import org.mobicents.media.server.component.audio.AudioMixer;
import org.mobicents.media.server.component.oob.OOBMixer;

public class MgcpMixerEndpoint
extends GenericMgcpEndpoint {
    private final AudioMixer inbandMixer;
    private final OOBMixer outbandMixer;

    public MgcpMixerEndpoint(EndpointIdentifier endpointId, AudioMixer inbandMixer, OOBMixer outbandMixer, MgcpConnectionProvider connectionProvider, MediaGroup mediaGroup) {
        super(endpointId, connectionProvider, mediaGroup);
        this.inbandMixer = inbandMixer;
        this.outbandMixer = outbandMixer;
        this.inbandMixer.addComponent(((MediaGroupImpl)this.mediaGroup).getAudioComponent());
    }

    @Override
    protected void onConnectionCreated(MgcpConnection connection) {
        this.inbandMixer.addComponent(connection.getAudioComponent());
        this.outbandMixer.addComponent(connection.getOutOfBandComponent());
    }

    @Override
    protected void onConnectionDeleted(MgcpConnection connection) {
        this.inbandMixer.release(connection.getAudioComponent());
        this.outbandMixer.release(connection.getOutOfBandComponent());
    }

    @Override
    protected void onActivated() {
        this.inbandMixer.start();
        this.outbandMixer.start();
    }

    @Override
    protected void onDeactivated() {
        this.inbandMixer.stop();
        this.outbandMixer.stop();
    }
}

