/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg;

import java.util.HashMap;
import java.util.Map;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;

public class GenericMgcpEvent
implements MgcpEvent {
    private final String pkg;
    private final String symbol;
    private final String signal;
    private final Map<String, String> parameters;
    private final StringBuilder builder;

    public GenericMgcpEvent(String pkg, String symbol, String signal) {
        this.pkg = pkg;
        this.symbol = symbol;
        this.signal = signal;
        this.parameters = new HashMap<String, String>(5);
        this.builder = new StringBuilder();
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getSignal() {
        return this.signal;
    }

    @Override
    public String getParameter(String type) {
        return this.parameters.get(type);
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String toString() {
        this.builder.setLength(0);
        this.builder.append(this.pkg).append("/").append(this.symbol).append("(");
        this.builder.append(this.pkg).append("/").append(this.signal);
        if (!this.parameters.isEmpty()) {
            for (String key : this.parameters.keySet()) {
                String value = this.parameters.get(key);
                this.builder.append(" ").append(key);
                if (value == null) continue;
                this.builder.append("=").append(value);
            }
        }
        this.builder.append(")");
        return this.builder.toString();
    }
}

