/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.transaction;

import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.control.mgcp.transaction.MgcpTransaction;

public class MgcpTransactionProvider {
    private final AtomicInteger idGenerator;
    private final int minId;
    private final int maxId;

    public MgcpTransactionProvider(int minId, int maxId) {
        this.minId = minId;
        this.maxId = maxId;
        this.idGenerator = new AtomicInteger(minId);
    }

    private synchronized void verifyIdRange() {
        if (this.idGenerator.get() > this.maxId) {
            this.idGenerator.set(this.minId);
        }
    }

    private int generateId() {
        this.verifyIdRange();
        return this.idGenerator.getAndIncrement();
    }

    public boolean isLocal(int transactionId) {
        return transactionId >= this.minId && transactionId <= this.maxId;
    }

    private MgcpTransaction provide(int transactionId) {
        return new MgcpTransaction(transactionId);
    }

    public MgcpTransaction provideRemote(int transactionId) throws IllegalArgumentException {
        if (this.isLocal(transactionId)) {
            throw new IllegalArgumentException("Transaction ID " + transactionId + " is local, hence managed by this provider.");
        }
        return this.provide(transactionId);
    }

    public MgcpTransaction provideLocal() {
        return this.provide(this.generateId());
    }
}

