/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.command;

import com.google.common.base.Optional;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.AbstractMgcpCommand;
import org.mobicents.media.control.mgcp.command.CrcxContext;
import org.mobicents.media.control.mgcp.command.MgcpCommandException;
import org.mobicents.media.control.mgcp.command.MgcpCommandResult;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpLocalConnection;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.exception.MgcpCallNotFoundException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionNotFound;
import org.mobicents.media.control.mgcp.exception.UnrecognizedMgcpNamespaceException;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptions;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.util.collections.Parameters;
import org.mobicents.media.server.spi.ConnectionMode;

public class CreateConnectionCommand
extends AbstractMgcpCommand {
    private static final Logger log = Logger.getLogger(CreateConnectionCommand.class);
    protected static final String WILDCARD_ALL = "*";
    protected static final String WILDCARD_ANY = "$";
    protected static final String ENDPOINT_ID_SEPARATOR = "@";

    public CreateConnectionCommand(int transactionId, Parameters<MgcpParameterType> parameters, MgcpEndpointManager endpointManager) {
        super(transactionId, parameters, endpointManager);
    }

    private int loadCallId(Parameters<MgcpParameterType> parameters) throws MgcpCommandException {
        Optional<Integer> callId = parameters.getIntegerBase16(MgcpParameterType.CALL_ID);
        if (!callId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.INCORRECT_CALL_ID);
        }
        return (Integer)callId.get();
    }

    private String loadEndpointId(Parameters<MgcpParameterType> parameters) throws MgcpCommandException {
        Optional<String> endpointId = parameters.getString(MgcpParameterType.ENDPOINT_ID);
        if (!endpointId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        if (((String)endpointId.get()).indexOf(WILDCARD_ALL) != -1) {
            throw new MgcpCommandException(MgcpResponseCode.WILDCARD_TOO_COMPLICATED);
        }
        return (String)endpointId.get();
    }

    private String loadSecondEndpointId(Parameters<MgcpParameterType> parameters) throws MgcpCommandException {
        Optional<String> secondEndpointId = parameters.getString(MgcpParameterType.SECOND_ENDPOINT);
        if (secondEndpointId.isPresent() && ((String)secondEndpointId.get()).indexOf(WILDCARD_ALL) != -1) {
            throw new MgcpCommandException(MgcpResponseCode.WILDCARD_TOO_COMPLICATED);
        }
        return (String)secondEndpointId.or((Object)"");
    }

    private String loadRemoteDescription(Parameters<MgcpParameterType> parameters) throws MgcpCommandException {
        Optional<String> remoteSdp = parameters.getString(MgcpParameterType.SDP);
        Optional<String> secondEndpointId = parameters.getString(MgcpParameterType.SECOND_ENDPOINT);
        if (secondEndpointId.isPresent() && remoteSdp.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.PROTOCOL_ERROR.code(), "Z2 and SDP present in message");
        }
        return (String)remoteSdp.or((Object)"");
    }

    private ConnectionMode loadConnectionMode(Parameters<MgcpParameterType> parameters) throws MgcpCommandException {
        Optional<String> mode = parameters.getString(MgcpParameterType.MODE);
        try {
            if (!mode.isPresent()) {
                throw new MgcpCommandException(MgcpResponseCode.INVALID_OR_UNSUPPORTED_MODE);
            }
            return ConnectionMode.fromDescription((String)((String)mode.get()));
        }
        catch (IllegalArgumentException e) {
            throw new MgcpCommandException(MgcpResponseCode.INVALID_OR_UNSUPPORTED_MODE);
        }
    }

    private MgcpEndpoint retrieveEndpoint(String endpointId) throws MgcpCommandException {
        MgcpEndpoint endpoint;
        int indexOfSeparator = endpointId.indexOf(ENDPOINT_ID_SEPARATOR);
        String localName = endpointId.substring(0, indexOfSeparator);
        int indexOfAll = endpointId.indexOf(WILDCARD_ANY);
        if (indexOfAll == -1) {
            endpoint = this.endpointManager.getEndpoint(endpointId);
            if (endpoint == null) {
                throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
            }
        } else {
            try {
                endpoint = this.endpointManager.registerEndpoint(localName.substring(0, indexOfAll));
            }
            catch (UnrecognizedMgcpNamespaceException e) {
                throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_NOT_AVAILABLE);
            }
        }
        return endpoint;
    }

    private MgcpConnection createRemoteConnection(int callId, ConnectionMode mode, MgcpEndpoint endpoint, CrcxContext context) throws MgcpConnectionException {
        MgcpConnection connection = endpoint.createConnection(callId, false);
        String localDescription = connection.halfOpen(new LocalConnectionOptions());
        context.setLocalDescription(localDescription);
        connection.setMode(mode);
        return connection;
    }

    private MgcpConnection createRemoteConnection(int callId, ConnectionMode mode, String remoteDescription, MgcpEndpoint endpoint, CrcxContext context) throws MgcpConnectionException {
        MgcpConnection connection = endpoint.createConnection(callId, false);
        String localDescription = connection.open(remoteDescription);
        context.setLocalDescription(localDescription);
        connection.setMode(mode);
        return connection;
    }

    private MgcpConnection createLocalConnection(int callId, ConnectionMode mode, MgcpEndpoint endpoint) throws MgcpConnectionException {
        MgcpConnection connection = endpoint.createConnection(callId, true);
        connection.open(null);
        connection.setMode(mode);
        return connection;
    }

    private void validateParameters(Parameters<MgcpParameterType> parameters, CrcxContext context) throws MgcpCommandException {
        context.setCallId(this.loadCallId(parameters));
        context.setEndpointId(this.loadEndpointId(parameters));
        context.setSecondEndpointId(this.loadSecondEndpointId(parameters));
        context.setRemoteDescription(this.loadRemoteDescription(parameters));
        context.setConnectionMode(this.loadConnectionMode(parameters));
    }

    private void executeCommand(CrcxContext context) throws MgcpCommandException, MgcpConnectionException {
        String endpointId = context.getEndpointId();
        String secondEndpointId = context.getSecondEndpointId();
        MgcpEndpoint endpoint1 = this.retrieveEndpoint(endpointId);
        MgcpEndpoint endpoint2 = secondEndpointId.isEmpty() ? null : this.retrieveEndpoint(secondEndpointId);
        context.setEndpointId(endpoint1.getEndpointId().toString());
        if (endpoint2 != null) {
            context.setSecondEndpointId(endpoint2.getEndpointId().toString());
        }
        if (endpoint2 == null) {
            MgcpConnection connection = context.getRemoteDescription().isEmpty() ? this.createRemoteConnection(context.getCallId(), context.getConnectionMode(), endpoint1, context) : this.createRemoteConnection(context.getCallId(), context.getConnectionMode(), context.getRemoteDescription(), endpoint1, context);
            context.setConnectionId(connection.getIdentifier());
        } else {
            MgcpConnection connection1 = this.createLocalConnection(context.getCallId(), context.getConnectionMode(), endpoint1);
            MgcpConnection connection2 = this.createLocalConnection(context.getCallId(), ConnectionMode.SEND_RECV, endpoint2);
            context.setConnectionId(connection1.getIdentifier());
            context.setSecondConnectionId(connection2.getIdentifier());
            ((MgcpLocalConnection)connection1).join((MgcpLocalConnection)connection2);
        }
    }

    private void rollback(CrcxContext context) {
        MgcpEndpoint endpoint2;
        int callId = context.getCallId();
        String endpointId = context.getEndpointId();
        String secondEndpointId = context.getSecondEndpointId();
        int connectionId = context.getConnectionId();
        int secondConnectionId = context.getSecondConnectionId();
        MgcpEndpoint endpoint1 = endpointId.isEmpty() ? null : this.endpointManager.getEndpoint(endpointId);
        MgcpEndpoint mgcpEndpoint = endpoint2 = secondEndpointId.isEmpty() ? null : this.endpointManager.getEndpoint(secondEndpointId);
        if (endpoint1 != null && connectionId > 0) {
            try {
                endpoint1.deleteConnection(callId, connectionId);
            }
            catch (MgcpCallNotFoundException | MgcpConnectionNotFound e) {
                log.error((Object)("Could not delete primary connection. " + e.getMessage()));
            }
        }
        if (endpoint2 != null && secondConnectionId > 0) {
            try {
                endpoint2.deleteConnection(callId, secondConnectionId);
            }
            catch (MgcpCallNotFoundException | MgcpConnectionNotFound e) {
                log.error((Object)("Could not delete secondary connection. " + e.getMessage()));
            }
        }
    }

    private MgcpCommandResult respond(CrcxContext context) {
        boolean successful;
        Parameters<MgcpParameterType> parameters = new Parameters<MgcpParameterType>();
        MgcpCommandResult result = new MgcpCommandResult(this.transactionId, context.getCode(), context.getMessage(), parameters);
        boolean bl = successful = context.getCode() < 300;
        if (successful) {
            this.translateContext(context, parameters);
        }
        return result;
    }

    private void translateContext(CrcxContext context, Parameters<MgcpParameterType> parameters) {
        String localDescription;
        String endpointId = context.getEndpointId();
        int connectionId = context.getConnectionId();
        if (!endpointId.isEmpty() && connectionId > 0) {
            parameters.put(MgcpParameterType.ENDPOINT_ID, endpointId);
            parameters.put(MgcpParameterType.CONNECTION_ID, Integer.toHexString(connectionId));
        }
        String secondEndpointId = context.getSecondEndpointId();
        int secondConnectionId = context.getSecondConnectionId();
        if (!secondEndpointId.isEmpty() && secondConnectionId > 0) {
            parameters.put(MgcpParameterType.SECOND_ENDPOINT, secondEndpointId);
            parameters.put(MgcpParameterType.CONNECTION_ID2, Integer.toHexString(secondConnectionId));
        }
        if (!(localDescription = context.getLocalDescription()).isEmpty()) {
            parameters.put(MgcpParameterType.SDP, localDescription);
        }
    }

    @Override
    public MgcpCommandResult call() {
        CrcxContext context = new CrcxContext();
        try {
            this.validateParameters(this.requestParameters, context);
            this.executeCommand(context);
            context.setCode(MgcpResponseCode.TRANSACTION_WAS_EXECUTED.code());
            context.setMessage(MgcpResponseCode.TRANSACTION_WAS_EXECUTED.message());
        }
        catch (RuntimeException | MgcpConnectionException e) {
            log.error((Object)("Unexpected error occurred during tx=" + this.transactionId + " execution. Rolling back."));
            this.rollback(context);
            context.setCode(MgcpResponseCode.PROTOCOL_ERROR.code());
            context.setMessage(MgcpResponseCode.PROTOCOL_ERROR.message());
        }
        catch (MgcpCommandException e) {
            log.error((Object)("Protocol error occurred during tx=" + this.transactionId + " execution: " + e.getMessage()));
            context.setCode(e.getCode());
            context.setMessage(e.getMessage());
        }
        return this.respond(context);
    }
}

