/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.command;

import com.google.common.base.Optional;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.AbstractMgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandException;
import org.mobicents.media.control.mgcp.command.MgcpCommandResult;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.exception.MgcpCallNotFoundException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionNotFound;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.util.collections.Parameters;

public class DeleteConnectionCommand
extends AbstractMgcpCommand {
    private static final Logger log = Logger.getLogger(DeleteConnectionCommand.class);

    public DeleteConnectionCommand(int transactionId, Parameters<MgcpParameterType> parameters, MgcpEndpointManager endpointManager) {
        super(transactionId, parameters, endpointManager);
    }

    private void validateParameters(Parameters<MgcpParameterType> parameters, DlcxContext context) throws MgcpCommandException, RuntimeException {
        Optional<Integer> connectionId;
        Optional<String> endpointId = parameters.getString(MgcpParameterType.ENDPOINT_ID);
        if (!endpointId.isPresent()) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        if (((String)endpointId.get()).contains("*") || ((String)endpointId.get()).contains("$")) {
            throw new MgcpCommandException(MgcpResponseCode.WILDCARD_TOO_COMPLICATED.code(), MgcpResponseCode.WILDCARD_TOO_COMPLICATED.message());
        }
        context.endpointId = (String)endpointId.get();
        Optional<Integer> callId = parameters.getIntegerBase16(MgcpParameterType.CALL_ID);
        if (callId.isPresent()) {
            context.callId = (Integer)callId.get();
        }
        if ((connectionId = this.requestParameters.getIntegerBase16(MgcpParameterType.CONNECTION_ID)).isPresent()) {
            context.connectionId = (Integer)connectionId.get();
            if (!callId.isPresent()) {
                throw new MgcpCommandException(MgcpResponseCode.INCORRECT_CALL_ID);
            }
        }
    }

    private void executeCommand(DlcxContext context) throws MgcpCommandException, MgcpCallNotFoundException, MgcpConnectionNotFound {
        String endpointId = context.endpointId;
        MgcpEndpoint endpoint = this.endpointManager.getEndpoint(endpointId);
        if (endpoint == null) {
            throw new MgcpCommandException(MgcpResponseCode.ENDPOINT_UNKNOWN);
        }
        int callId = context.callId;
        int connectionId = context.connectionId;
        if (connectionId == -1) {
            if (callId == -1) {
                endpoint.deleteConnections();
            } else {
                try {
                    endpoint.deleteConnections(callId);
                }
                catch (MgcpCallNotFoundException e) {}
            }
        } else {
            MgcpConnection deleted = endpoint.deleteConnection(callId, connectionId);
            context.connectionParams = "PS=0, PR=0";
        }
    }

    private MgcpCommandResult respond(DlcxContext context) {
        boolean successful;
        Parameters<MgcpParameterType> parameters = new Parameters<MgcpParameterType>();
        MgcpCommandResult result = new MgcpCommandResult(this.transactionId, context.code, context.message, parameters);
        boolean bl = successful = context.code < 300;
        if (successful) {
            this.translateContext(context, parameters);
        }
        return result;
    }

    private void translateContext(DlcxContext context, Parameters<MgcpParameterType> parameters) {
        String connectionParams = context.connectionParams;
        if (!connectionParams.isEmpty()) {
            parameters.put(MgcpParameterType.CONNECTION_PARAMETERS, connectionParams);
        }
    }

    @Override
    public MgcpCommandResult call() {
        DlcxContext context = new DlcxContext();
        try {
            this.validateParameters(this.requestParameters, context);
            this.executeCommand(context);
            context.code = MgcpResponseCode.TRANSACTION_WAS_EXECUTED.code();
            context.message = MgcpResponseCode.TRANSACTION_WAS_EXECUTED.message();
        }
        catch (RuntimeException e) {
            log.error((Object)("Unexpected error occurred during tx=" + this.transactionId + " execution. Rolling back."));
            context.code = MgcpResponseCode.PROTOCOL_ERROR.code();
            context.message = MgcpResponseCode.PROTOCOL_ERROR.message();
        }
        catch (MgcpCallNotFoundException e) {
            log.error((Object)("Protocol error occurred during tx=" + this.transactionId + " execution: " + e.getMessage()));
            context.code = MgcpResponseCode.INCORRECT_CALL_ID.code();
            context.message = MgcpResponseCode.INCORRECT_CALL_ID.message();
        }
        catch (MgcpConnectionNotFound e) {
            log.error((Object)("Protocol error occurred during tx=" + this.transactionId + " execution: " + e.getMessage()));
            context.code = MgcpResponseCode.INCORRECT_CONNECTION_ID.code();
            context.message = MgcpResponseCode.INCORRECT_CONNECTION_ID.message();
        }
        catch (MgcpCommandException e) {
            log.error((Object)("Protocol error occurred during tx=" + this.transactionId + " execution: " + e.getMessage()));
            context.code = e.getCode();
            context.message = e.getMessage();
        }
        return this.respond(context);
    }

    private class DlcxContext {
        private int callId = -1;
        private String endpointId = "";
        private int connectionId = -1;
        private String connectionParams = "";
        private int code = MgcpResponseCode.ABORTED.code();
        private String message = MgcpResponseCode.ABORTED.message();
    }
}

