/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionState;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.spi.ConnectionMode;

public abstract class AbstractMgcpConnection
implements MgcpConnection {
    private final int identifier;
    private final String hexIdentifier;
    private ConnectionMode mode;
    protected volatile MgcpConnectionState state;
    protected final Object stateLock;

    public AbstractMgcpConnection(int identifier) {
        this.identifier = identifier;
        this.hexIdentifier = Integer.toHexString(identifier);
        this.mode = ConnectionMode.INACTIVE;
        this.state = MgcpConnectionState.CLOSED;
        this.stateLock = new Object();
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getHexIdentifier() {
        return this.hexIdentifier;
    }

    @Override
    public ConnectionMode getMode() {
        return this.mode;
    }

    @Override
    public MgcpConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(ConnectionMode mode) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (MgcpConnectionState.CLOSED.equals((Object)this.state)) {
                throw new IllegalStateException("Cannot update mode because connection is closed.");
            }
        }
        this.mode = mode;
    }

    @Override
    public abstract AudioComponent getAudioComponent();

    @Override
    public abstract OOBComponent getOutOfBandComponent();
}

