/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.connection.AbstractMgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionState;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptions;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.LocalDataChannel;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ModeNotSupportedException;

public class MgcpLocalConnection
extends AbstractMgcpConnection {
    private static final Logger log = Logger.getLogger(MgcpLocalConnection.class);
    private final LocalDataChannel audioChannel;

    public MgcpLocalConnection(int identifier, ChannelsManager channelProvider) {
        super(identifier);
        this.audioChannel = channelProvider.getLocalChannel();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String halfOpen(LocalConnectionOptions options) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSED: {
                    this.state = MgcpConnectionState.HALF_OPEN;
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot half-open connection " + this.getHexIdentifier() + " because state is " + this.state.name());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String open(String sdp) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSED: 
                case HALF_OPEN: {
                    this.state = MgcpConnectionState.OPEN;
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot open connection " + this.getHexIdentifier() + " because state is " + this.state.name());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(MgcpLocalConnection otherConnection) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case OPEN: {
                    try {
                        this.audioChannel.join(otherConnection.audioChannel);
                        break;
                    }
                    catch (IOException e) {
                        throw new MgcpConnectionException("Cannot join connection " + this.getHexIdentifier() + " to connection " + otherConnection.getHexIdentifier(), e);
                    }
                }
                default: {
                    throw new MgcpConnectionException("Cannot join connection " + this.getHexIdentifier() + " to connection " + otherConnection.getHexIdentifier() + " because current state is not OPEN");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case HALF_OPEN: 
                case OPEN: {
                    this.setMode(ConnectionMode.INACTIVE);
                    this.state = MgcpConnectionState.CLOSED;
                    this.audioChannel.unjoin();
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot close connection " + this.getHexIdentifier() + " because state is " + this.state.name());
                }
            }
        }
    }

    @Override
    public void setMode(ConnectionMode mode) throws IllegalStateException {
        try {
            this.audioChannel.updateMode(mode);
        }
        catch (ModeNotSupportedException e) {
            log.warn((Object)("Could not update data channel mode of local connection " + this.getHexIdentifier()));
        }
        super.setMode(mode);
    }

    @Override
    public AudioComponent getAudioComponent() {
        return this.audioChannel.getAudioComponent();
    }

    @Override
    public OOBComponent getOutOfBandComponent() {
        return this.audioChannel.getOOBComponent();
    }
}

