/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.connection.AbstractMgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionState;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.listener.MgcpConnectionListener;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptionType;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptions;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtp.CnameGenerator;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.channels.AudioChannel;
import org.mobicents.media.server.impl.rtp.channels.MediaChannel;
import org.mobicents.media.server.impl.rtp.channels.MediaChannelProvider;
import org.mobicents.media.server.impl.rtp.sdp.SdpFactory;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionDescriptionParser;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.spi.ConnectionMode;

public class MgcpRemoteConnection
extends AbstractMgcpConnection
implements RtpListener {
    private static final Logger log = Logger.getLogger(MgcpRemoteConnection.class);
    private final String localAddress;
    private final String externalAddress;
    private final String cname;
    private boolean outbound;
    private boolean webrtc;
    private SessionDescription localSdp;
    private SessionDescription remoteSdp;
    private final AudioChannel audioChannel;
    private MgcpConnectionListener connectionListener;

    public MgcpRemoteConnection(int identifier, MediaChannelProvider channelProvider) {
        super(identifier);
        this.localAddress = channelProvider.getLocalAddress();
        this.externalAddress = channelProvider.getExternalAddress();
        this.cname = CnameGenerator.generateCname();
        this.outbound = false;
        this.webrtc = false;
        this.localSdp = null;
        this.remoteSdp = null;
        this.audioChannel = channelProvider.provideAudioChannel();
        this.audioChannel.setCname(this.cname);
    }

    public void setConnectionListener(MgcpConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void setMode(ConnectionMode mode) throws IllegalStateException {
        super.setMode(mode);
        this.audioChannel.setConnectionMode(mode);
    }

    @Override
    public String halfOpen(LocalConnectionOptions options) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSED: {
                    this.state = MgcpConnectionState.HALF_OPEN;
                    String webrtcOption = options.get(LocalConnectionOptionType.WEBRTC);
                    this.outbound = true;
                    this.webrtc = webrtcOption != null && webrtcOption.equals("true");
                    this.audioChannel.open();
                    try {
                        this.audioChannel.bind(false, this.webrtc);
                    }
                    catch (IOException e) {
                        throw new MgcpConnectionException("Could not bind audio channel " + this.cname, e);
                    }
                    if (this.webrtc) {
                        this.audioChannel.enableICE(this.externalAddress, true);
                        this.audioChannel.enableDTLS();
                    }
                    this.localSdp = SdpFactory.buildSdp((boolean)true, (String)this.localAddress, (String)this.externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel});
                    return this.localSdp.toString();
                }
            }
            throw new MgcpConnectionException("Cannot half-open connection " + this.getHexIdentifier() + " because state is " + this.state.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String open(String sdp) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSED: 
                case HALF_OPEN: {
                    this.state = MgcpConnectionState.OPEN;
                    try {
                        this.remoteSdp = SessionDescriptionParser.parse((String)sdp);
                    }
                    catch (SdpException e) {
                        throw new MgcpConnectionException(e.getMessage(), e);
                    }
                    this.openConnection();
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot open connection " + this.getHexIdentifier() + " because state is " + this.state.name());
                }
            }
        }
        return this.localSdp.toString();
    }

    private void openConnection() throws MgcpConnectionException {
        this.audioChannel.open();
        try {
            if (this.outbound) {
                this.openOutboundConnection();
            } else {
                this.openInboundConnection();
            }
        }
        catch (IOException e) {
            throw new MgcpConnectionException(e.getMessage(), e);
        }
    }

    private void openInboundConnection() throws IOException {
        MediaDescriptionField remoteApplication;
        this.audioChannel.open();
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        this.setupAudioChannelInbound(remoteAudio);
        this.localSdp = SdpFactory.buildSdp((boolean)false, (String)this.localAddress, (String)this.externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel});
        MediaDescriptionField remoteVideo = this.remoteSdp.getMediaDescription("video");
        if (remoteVideo != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteVideo);
        }
        if ((remoteApplication = this.remoteSdp.getMediaDescription("application")) != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteApplication);
        }
    }

    private void setupAudioChannelInbound(MediaDescriptionField remoteAudio) throws IOException {
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        this.audioChannel.bind(false, remoteAudio.isRtcpMux());
        boolean enableIce = remoteAudio.containsIce();
        if (enableIce) {
            this.audioChannel.enableICE(this.externalAddress, remoteAudio.isRtcpMux());
        } else {
            String remoteAddr = remoteAudio.getConnection().getAddress();
            this.audioChannel.connectRtp(remoteAddr, remoteAudio.getPort());
            this.audioChannel.connectRtcp(remoteAddr, remoteAudio.getRtcpPort());
        }
        boolean enableDtls = this.remoteSdp.containsDtls();
        if (enableDtls) {
            FingerprintAttribute fingerprint = this.remoteSdp.getFingerprint(this.audioChannel.getMediaType());
            this.audioChannel.enableDTLS(fingerprint.getHashFunction(), fingerprint.getFingerprint());
        }
    }

    private void openOutboundConnection() throws IOException {
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        if (this.audioChannel.isDtlsEnabled()) {
            FingerprintAttribute fingerprint = remoteAudio.getFingerprint();
            this.audioChannel.setRemoteFingerprint(fingerprint.getHashFunction(), fingerprint.getFingerprint());
        }
        this.setupAudioChannelOutbound(remoteAudio);
    }

    private void setupAudioChannelOutbound(MediaDescriptionField remoteAudio) throws IOException {
        boolean connectNow;
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        String remoteRtpAddress = remoteAudio.getConnection().getAddress();
        int remoteRtpPort = remoteAudio.getPort();
        boolean bl = connectNow = !this.outbound || !this.audioChannel.isIceEnabled();
        if (connectNow) {
            this.audioChannel.connectRtp(remoteRtpAddress, remoteRtpPort);
            boolean remoteRtcpMux = remoteAudio.isRtcpMux();
            if (remoteRtcpMux) {
                this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort);
            } else {
                RtcpAttribute remoteRtcp = remoteAudio.getRtcp();
                if (remoteRtcp == null) {
                    this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort + 1);
                } else {
                    String remoteRtcpAddress = remoteRtcp.getAddress();
                    if (remoteRtcpAddress == null) {
                        remoteRtcpAddress = remoteRtpAddress;
                    }
                    int remoteRtcpPort = remoteRtcp.getPort();
                    this.audioChannel.connectRtcp(remoteRtcpAddress, remoteRtcpPort);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case HALF_OPEN: 
                case OPEN: {
                    this.setMode(ConnectionMode.INACTIVE);
                    this.state = MgcpConnectionState.CLOSED;
                    if (this.audioChannel.isOpen()) {
                        this.audioChannel.close();
                    }
                    this.reset();
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot close connection " + this.getHexIdentifier() + "because state is " + this.state.name());
                }
            }
        }
    }

    @Override
    public AudioComponent getAudioComponent() {
        return this.audioChannel.getAudioComponent();
    }

    @Override
    public OOBComponent getOutOfBandComponent() {
        return this.audioChannel.getAudioOobComponent();
    }

    public void onRtpFailure(Throwable e) {
        String message = "RTP channel failure on connection " + this.cname + "!";
        if (e != null && e.getMessage() != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtpFailure(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRtpFailure(String message) {
        try {
            this.close();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to elegantly close connection " + this.cname + " after RTP failure"), (Throwable)e);
        }
        finally {
            if (this.connectionListener != null) {
                this.connectionListener.onConnectionFailure(this);
            }
        }
    }

    public void onRtcpFailure(Throwable e) {
        String message = "Closing RTCP channel on connection " + this.cname + " due to failure!";
        if (e != null && e.getMessage() != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtcpFailure(message);
    }

    public void onRtcpFailure(String e) {
        log.warn((Object)e);
    }

    private void reset() {
        this.outbound = false;
        this.webrtc = false;
        this.localSdp = null;
        this.remoteSdp = null;
    }
}

