/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.controller;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.MgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandProvider;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.exception.DuplicateMgcpTransactionException;
import org.mobicents.media.control.mgcp.exception.MgcpTransactionNotFoundException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpResponse;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.network.MgcpChannel;
import org.mobicents.media.control.mgcp.transaction.TransactionManager;
import org.mobicents.media.server.spi.ControlProtocol;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointInstaller;
import org.mobicents.media.server.spi.ServerManager;

public class MgcpController
implements ServerManager,
MgcpMessageObserver {
    private static final Logger log = Logger.getLogger(MgcpController.class);
    private final MgcpChannel channel;
    private final TransactionManager transactions;
    private final MgcpEndpointManager endpoints;
    private final MgcpCommandProvider commands;
    private boolean active;

    public MgcpController(MgcpChannel channel, TransactionManager transactions, MgcpEndpointManager endpoints, MgcpCommandProvider commands) {
        this.channel = channel;
        this.transactions = transactions;
        this.endpoints = endpoints;
        this.commands = commands;
        this.active = false;
    }

    public ControlProtocol getControlProtocol() {
        return ControlProtocol.MGPC;
    }

    public void activate() throws IllegalStateException {
        if (this.active) {
            throw new IllegalStateException("Controller is already active");
        }
        try {
            this.channel.open();
            this.channel.observe(this);
            this.transactions.observe(this);
            this.endpoints.observe(this);
            this.active = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void deactivate() throws IllegalStateException {
        if (!this.active) {
            throw new IllegalStateException("Controller is already inactive");
        }
        this.channel.close();
        this.channel.forget(this);
        this.transactions.forget(this);
        this.endpoints.forget(this);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void onStarted(Endpoint endpoint, EndpointInstaller installer) {
    }

    public void onStopped(Endpoint endpoint) {
    }

    @Override
    public void onMessage(MgcpMessage message, MessageDirection direction) {
        switch (direction) {
            case INCOMING: {
                if (message.isRequest()) {
                    this.onIncomingRequest((MgcpRequest)message);
                    break;
                }
                this.onIncomingResponse((MgcpResponse)message);
                break;
            }
            case OUTGOING: {
                if (message.isRequest()) {
                    this.onOutgoingRequest((MgcpRequest)message);
                    break;
                }
                this.onOutgoingResponse((MgcpResponse)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message direction: " + direction.name());
            }
        }
    }

    private void onIncomingRequest(MgcpRequest request) {
        MgcpCommand command = this.commands.provide(request.getRequestType(), request.getTransactionId(), request.getParameters());
        try {
            this.transactions.process(request, command);
        }
        catch (DuplicateMgcpTransactionException e) {
            MgcpResponseCode provisional = MgcpResponseCode.TRANSACTION_BEING_EXECUTED;
            try {
                this.sendResponse(request.getTransactionId(), provisional.code(), provisional.message());
            }
            catch (IOException e1) {
                log.error((Object)("Could not send provisional response to call agent, regarding transaction " + request.getTransactionId()), (Throwable)e);
            }
        }
    }

    private void onOutgoingRequest(MgcpRequest request) {
        try {
            this.transactions.process(request, null);
            this.channel.send(request);
        }
        catch (DuplicateMgcpTransactionException e) {
            log.error((Object)(e.getMessage() + ". Request wont' be sent to call agent."));
        }
        catch (IOException e) {
            log.error((Object)("Could not send MGCP request to call agent: " + request.toString()), (Throwable)e);
        }
    }

    private void onIncomingResponse(MgcpResponse response) {
        try {
            this.transactions.process(response);
        }
        catch (MgcpTransactionNotFoundException e) {
            log.error((Object)e.getMessage());
        }
    }

    private void onOutgoingResponse(MgcpResponse response) {
        try {
            this.transactions.process(response);
            this.channel.send(response);
        }
        catch (MgcpTransactionNotFoundException e) {
            log.error((Object)(e.getMessage() + ". Response won't be sent to call agent."));
        }
        catch (IOException e) {
            log.error((Object)("Could not send MGCP response to call agent: " + response.toString()), (Throwable)e);
        }
    }

    private void sendResponse(int transactionId, int code, String message) throws IOException {
        MgcpResponse response = new MgcpResponse();
        response.setTransactionId(transactionId);
        response.setCode(code);
        response.setMessage(message);
        this.channel.send(response);
    }
}

