/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.message;

import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.exception.MgcpParseException;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptionType;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptions;

public class LocalConnectionOptionsParser {
    private static final Logger log = Logger.getLogger(LocalConnectionOptionsParser.class);

    public LocalConnectionOptions parse(String options) throws MgcpParseException {
        LocalConnectionOptions obj = new LocalConnectionOptions();
        try {
            String[] tokens;
            for (String token : tokens = options.split(",")) {
                int separator = (token = token.trim()).indexOf(":");
                if (separator == -1) {
                    LocalConnectionOptionType option = LocalConnectionOptionType.fromCode(token);
                    obj.add(option, "");
                    continue;
                }
                String code = token.substring(0, separator);
                try {
                    LocalConnectionOptionType option = LocalConnectionOptionType.fromCode(code);
                    String value = token.substring(separator + 1);
                    obj.add(option, value);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("Skipping unknown option: " + code));
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new MgcpParseException("Could not parse Local Connection Options.", e);
        }
    }
}

