/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.message;

import com.google.common.base.Optional;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptions;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpRequestType;

public class MgcpRequest
extends MgcpMessage {
    public static final String VERSION = "MGCP 1.0";
    private MgcpRequestType requestType;
    private final LocalConnectionOptions lcOptions = new LocalConnectionOptions();
    private final StringBuilder builder = new StringBuilder();

    public MgcpRequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(MgcpRequestType requestType) {
        this.requestType = requestType;
    }

    public String getEndpointId() {
        return (String)this.parameters.getString(MgcpParameterType.ENDPOINT_ID).orNull();
    }

    public void setEndpointId(String endpointId) {
        this.parameters.put(MgcpParameterType.ENDPOINT_ID, endpointId);
    }

    public LocalConnectionOptions getLocalConnectionOptions() {
        return this.lcOptions;
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public String toString() {
        this.builder.setLength(0);
        this.builder.append(this.requestType.name()).append(" ").append(this.transactionId).append(" ").append(this.getEndpointId()).append(" ").append(VERSION).append(System.lineSeparator());
        for (MgcpParameterType key : this.parameters.keySet()) {
            Optional<String> value;
            if (MgcpParameterType.ENDPOINT_ID.equals((Object)key) || !(value = this.parameters.getString(key)).isPresent()) continue;
            this.builder.append(key.getCode()).append(":").append((String)value.get()).append(System.lineSeparator());
        }
        return this.builder.toString();
    }
}

