/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.network;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpMessageParser;
import org.mobicents.media.control.mgcp.message.MgcpMessageSubject;
import org.mobicents.media.control.mgcp.network.MgcpPacketHandler;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.io.network.channel.Channel;
import org.mobicents.media.server.io.network.channel.MultiplexedChannel;
import org.mobicents.media.server.io.network.channel.PacketHandler;

public class MgcpChannel
extends MultiplexedChannel
implements MgcpMessageSubject {
    private static final Logger log = Logger.getLogger(MgcpChannel.class);
    private final UdpManager networkManager;
    private final SocketAddress bindAddress;
    private boolean open;
    private final MgcpPacketHandler mgcpHandler;
    private final Collection<MgcpMessageObserver> observers;

    public MgcpChannel(SocketAddress bindAddress, UdpManager networkManager) {
        this.networkManager = networkManager;
        this.bindAddress = bindAddress;
        this.open = false;
        this.mgcpHandler = new MgcpPacketHandler(new MgcpMessageParser(), this);
        this.handlers.addHandler((PacketHandler)this.mgcpHandler);
        this.observers = new CopyOnWriteArrayList<MgcpMessageObserver>();
    }

    public void open() throws IllegalStateException, IOException {
        if (this.open) {
            throw new IllegalStateException("MGCP channel is already open.");
        }
        this.selectionKey = this.networkManager.open((Channel)this);
        this.dataChannel = (DatagramChannel)this.selectionKey.channel();
        try {
            this.dataChannel.bind(this.bindAddress);
        }
        catch (IOException e) {
            log.error((Object)"BOMBED!!");
            this.close();
            throw e;
        }
        this.open = true;
        if (log.isInfoEnabled()) {
            log.info((Object)("MGCP Channel is open on " + this.bindAddress.toString()));
        }
    }

    public void close() throws IllegalStateException {
        if (this.open) {
            super.close();
            this.open = false;
            if (log.isInfoEnabled()) {
                log.info((Object)"MGCP Channel is closed");
            }
        } else {
            throw new IllegalStateException("MGCP channel is already closed.");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void queueData(byte[] data) {
        super.queueData(data);
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notify(Object originator, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(message, direction);
        }
    }

    public void send(MgcpMessage message) throws IOException {
        this.queueData(message.toString().getBytes());
        this.send();
    }
}

