/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg;

import org.mobicents.media.control.mgcp.exception.MgcpParseException;
import org.mobicents.media.control.mgcp.pkg.MgcpActionType;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.base.MgcpEventType;
import org.mobicents.media.control.mgcp.pkg.exception.UnrecognizedMgcpActionException;
import org.mobicents.media.control.mgcp.pkg.exception.UnrecognizedMgcpEventException;
import org.mobicents.media.control.mgcp.pkg.exception.UnrecognizedMgcpPackageException;

public class MgcpRequestedEventsParser {
    private static final String EVENT_SEPARATOR = "/";
    private static final String ACTION_START_SEPARATOR = "(";
    private static final String ACTION_END_SEPARATOR = ")";

    public static MgcpRequestedEvent[] parse(String requestedEvents) throws UnrecognizedMgcpPackageException, UnrecognizedMgcpEventException, UnrecognizedMgcpActionException, MgcpParseException {
        String[] tokens = requestedEvents.split(",");
        MgcpRequestedEvent[] events = new MgcpRequestedEvent[tokens.length];
        for (int i = 0; i < events.length; ++i) {
            events[i] = MgcpRequestedEventsParser.parseSingle(tokens[i]);
        }
        return events;
    }

    private static MgcpRequestedEvent parseSingle(String requestedEvent) throws UnrecognizedMgcpPackageException, UnrecognizedMgcpEventException, UnrecognizedMgcpActionException, MgcpParseException {
        int indexOfEvent = requestedEvent.indexOf(EVENT_SEPARATOR);
        if (indexOfEvent == -1) {
            throw new UnrecognizedMgcpPackageException("Missing event name separator");
        }
        int indexOfActionStart = requestedEvent.indexOf(ACTION_START_SEPARATOR);
        if (indexOfActionStart == -1) {
            throw new MgcpParseException("Missing action start separator");
        }
        int indexOfActionEnd = requestedEvent.indexOf(ACTION_END_SEPARATOR);
        if (indexOfActionEnd == -1) {
            throw new MgcpParseException("Missing action end separator");
        }
        try {
            String packageName = requestedEvent.substring(0, indexOfEvent);
            if (!MgcpRequestedEventsParser.validatePackage(packageName)) {
                throw new UnrecognizedMgcpPackageException("Unrecognized package: " + packageName);
            }
            String eventName = requestedEvent.substring(indexOfEvent + 1, indexOfActionStart);
            if (!MgcpRequestedEventsParser.validateEvent(eventName)) {
                throw new UnrecognizedMgcpEventException("Unrecognized event: " + eventName);
            }
            String action = requestedEvent.substring(indexOfActionStart + 1, indexOfActionEnd);
            MgcpActionType actionType = MgcpActionType.fromSymbol(action);
            if (actionType == null) {
                throw new UnrecognizedMgcpActionException("Unrecognized action: " + eventName);
            }
            return new MgcpRequestedEvent(packageName, eventName, actionType);
        }
        catch (RuntimeException e) {
            throw new MgcpParseException("Could not parse requested event.", e);
        }
    }

    private static boolean validatePackage(String name) {
        switch (name) {
            case "AU": {
                return true;
            }
        }
        return false;
    }

    private static boolean validateEvent(String name) {
        return MgcpEventType.fromSymbol(name) != null;
    }
}

