/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg;

import java.text.ParseException;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;

public class NotifiedEntityParser {
    private static final String DOMAIN_SEPARATOR = "@";
    private static final String PORT_SEPARATOR = ":";

    public static NotifiedEntity parse(String notifiedEntity) throws ParseException {
        int indexOfDomain = notifiedEntity.indexOf(DOMAIN_SEPARATOR);
        if (indexOfDomain == -1) {
            throw new ParseException("Missing domain: " + notifiedEntity, indexOfDomain);
        }
        String localName = notifiedEntity.substring(0, indexOfDomain);
        if (localName.isEmpty()) {
            throw new ParseException("Missing local name: " + notifiedEntity, 0);
        }
        int indexOfPort = notifiedEntity.indexOf(PORT_SEPARATOR);
        String domainName = indexOfPort == -1 ? notifiedEntity.substring(indexOfDomain + 1) : notifiedEntity.substring(indexOfDomain + 1, indexOfPort);
        if (domainName.isEmpty()) {
            throw new ParseException("Missing domain name: " + notifiedEntity, indexOfDomain);
        }
        if (indexOfPort > -1 && indexOfPort + 1 == notifiedEntity.length()) {
            throw new ParseException("Missing port: " + notifiedEntity, indexOfDomain);
        }
        int port = 0;
        if (indexOfPort > -1) {
            try {
                port = Integer.parseInt(notifiedEntity.substring(indexOfPort + 1));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Wrong port format: " + notifiedEntity, indexOfDomain);
            }
        }
        return new NotifiedEntity(localName, domainName, port);
    }
}

