/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg.au;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.pkg.AbstractMgcpSignal;
import org.mobicents.media.control.mgcp.pkg.SignalType;
import org.mobicents.media.control.mgcp.pkg.au.OperationComplete;
import org.mobicents.media.control.mgcp.pkg.au.OperationFailed;
import org.mobicents.media.control.mgcp.pkg.au.Playlist;
import org.mobicents.media.control.mgcp.pkg.au.ReturnCode;
import org.mobicents.media.control.mgcp.pkg.au.SignalParameters;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;

public class PlayAnnouncement
extends AbstractMgcpSignal
implements PlayerListener {
    private static final Logger log = Logger.getLogger(PlayAnnouncement.class);
    private static final String SIGNAL = "pa";
    private static final int ITERATIONS = 1;
    private static final int INTERVAL = 10;
    private final Player player;
    private final Playlist playlist;
    private final long duration = this.getDuration();
    private final long interval = this.getInterval();

    public PlayAnnouncement(Player player, int requestId, Map<String, String> parameters) {
        super("AU", SIGNAL, SignalType.TIME_OUT, requestId, parameters);
        this.playlist = new Playlist(this.getSegments(), this.getIterations());
        this.player = player;
        this.player.setDuration(this.duration);
        this.player.setMediaTime(0L);
        try {
            this.player.addListener((PlayerListener)this);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many listeners for audio player", (Throwable)e);
        }
    }

    private String[] getSegments() {
        return ((String)Optional.fromNullable((Object)this.getParameter(SignalParameters.ANNOUNCEMENT.symbol())).or((Object)"")).split(",");
    }

    private int getIterations() {
        return (Integer)Optional.fromNullable((Object)this.getParameter(SignalParameters.ITERATIONS.symbol())).transform((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                try {
                    return input == null || input.isEmpty() ? null : Integer.valueOf(Integer.parseInt(input));
                }
                catch (Exception e) {
                    log.error((Object)("Could not parse ITERATIONS=" + input + " to integer. Using default value: " + 1));
                    return null;
                }
            }
        }).or((Object)1);
    }

    private long getDuration() {
        return (Long)Optional.fromNullable((Object)this.getParameter(SignalParameters.DURATION.symbol())).transform((Function)new Function<String, Long>(){

            public Long apply(String input) {
                try {
                    return input == null || input.isEmpty() ? null : Long.valueOf(Long.parseLong(input));
                }
                catch (Exception e) {
                    log.error((Object)("Could not parse DURATION=" + input + " to long. Duration will be track length."));
                    return null;
                }
            }
        }).or((Object)-1L);
    }

    private long getInterval() {
        return (long)((Integer)Optional.fromNullable((Object)this.getParameter(SignalParameters.INTERVAL.symbol())).transform((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                try {
                    return input == null || input.isEmpty() ? null : Integer.valueOf(Integer.parseInt(input));
                }
                catch (Exception e) {
                    log.error((Object)("Could not parse INTERVAL=" + input + " to long. Using default value: " + 10));
                    return null;
                }
            }
        }).or((Object)10)).intValue() * 1000000L;
    }

    @Override
    protected boolean isParameterSupported(String name) {
        SignalParameters parameter = SignalParameters.fromSymbol(name);
        if (parameter == null) {
            return false;
        }
        switch (parameter) {
            case ANNOUNCEMENT: 
            case ITERATIONS: 
            case INTERVAL: 
            case DURATION: 
            case SPEED: 
            case VOLUME: {
                return true;
            }
        }
        return false;
    }

    private void playAnnouncement(String segment, long delay) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Playing announcement " + segment));
        }
        try {
            this.player.setInitialDelay(delay);
            this.player.setURL(segment);
            this.player.activate();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Cannot play audio track. Malformed URL: " + segment));
            this.fireOF(ReturnCode.BAD_AUDIO_ID.code());
        }
        catch (ResourceUnavailableException e) {
            this.fireOF(ReturnCode.MISMATCH_BETWEEN_PLAY_SPECIFICATION_AND_PROVISIONED_DATA.code());
        }
    }

    @Override
    public void execute() {
        if (this.executing.getAndSet(true)) {
            throw new IllegalStateException("Already executing.");
        }
        String announcement = this.playlist.next();
        if (announcement == null || announcement.isEmpty()) {
            this.executing.set(false);
            this.fireOF(ReturnCode.BAD_AUDIO_ID.code());
        } else {
            this.playAnnouncement(announcement, 0L);
        }
    }

    @Override
    public void cancel() {
        if (this.executing.getAndSet(false)) {
            this.player.deactivate();
        }
    }

    public void process(PlayerEvent event) {
        switch (event.getID()) {
            case 2: {
                String announcement;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Announcement " + this.playlist.current() + " has completed."));
                }
                if ((announcement = this.playlist.next()).isEmpty() || !this.isExecuting()) {
                    this.player.removeListener((PlayerListener)this);
                    this.fireOC(ReturnCode.SUCCESS.code());
                    break;
                }
                this.playAnnouncement(announcement, this.interval);
                break;
            }
            case 3: {
                if (!this.executing.getAndSet(false)) break;
                this.player.removeListener((PlayerListener)this);
                this.fireOF(ReturnCode.UNSPECIFIED_FAILURE.code());
                break;
            }
        }
    }

    private void fireOC(int code) {
        this.notify(this, new OperationComplete(this.getSymbol(), code));
    }

    private void fireOF(int code) {
        this.notify(this, new OperationFailed(this.getSymbol(), code));
    }
}

