/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.transaction;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.MgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandResult;
import org.mobicents.media.control.mgcp.exception.DuplicateMgcpTransactionException;
import org.mobicents.media.control.mgcp.exception.MgcpTransactionNotFoundException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpResponse;
import org.mobicents.media.control.mgcp.transaction.MgcpTransaction;
import org.mobicents.media.control.mgcp.transaction.MgcpTransactionProvider;
import org.mobicents.media.control.mgcp.transaction.TransactionManager;
import org.mobicents.media.control.mgcp.util.collections.Parameters;

public class MgcpTransactionManager
implements TransactionManager {
    private static final Logger log = Logger.getLogger(MgcpTransactionManager.class);
    private final ListeningExecutorService executor;
    private final MgcpCommandCallback commandCallback;
    private final MgcpTransactionProvider transactionProvider;
    private final ConcurrentHashMap<Integer, MgcpTransaction> transactions;
    private final Collection<MgcpMessageObserver> observers;

    public MgcpTransactionManager(MgcpTransactionProvider transactionProvider, ListeningExecutorService executor) {
        this.executor = executor;
        this.commandCallback = new MgcpCommandCallback();
        this.transactionProvider = transactionProvider;
        this.transactions = new ConcurrentHashMap(500);
        this.observers = new CopyOnWriteArrayList<MgcpMessageObserver>();
    }

    private MgcpTransaction createTransaction(MgcpRequest request) throws DuplicateMgcpTransactionException {
        MgcpTransaction transaction;
        int transactionId = request.getTransactionId();
        if (transactionId == 0) {
            transaction = this.transactionProvider.provideLocal();
            request.setTransactionId(transaction.getId());
            transactionId = transaction.getId();
        } else {
            transaction = this.transactionProvider.provideRemote(transactionId);
        }
        MgcpTransaction old = this.transactions.putIfAbsent(transaction.getId(), transaction);
        if (old != null) {
            throw new DuplicateMgcpTransactionException("Transaction " + transactionId + " already exists.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new transaction " + transactionId + " to process request"));
        }
        return transaction;
    }

    boolean contains(int transactionId) {
        return this.transactions.containsKey(transactionId);
    }

    @Override
    public void process(MgcpRequest request, MgcpCommand command) throws DuplicateMgcpTransactionException {
        this.createTransaction(request);
        if (command != null) {
            ListenableFuture future = this.executor.submit((Callable)command);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)this.commandCallback);
        }
    }

    @Override
    public void process(MgcpResponse response) throws MgcpTransactionNotFoundException {
        MgcpTransaction transaction = this.transactions.remove(response.getTransactionId());
        if (transaction == null) {
            throw new MgcpTransactionNotFoundException("Could not find transaction " + response.getTransactionId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closed transaction " + response.getTransactionId() + " with code " + response.getCode()));
        }
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notify(Object originator, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(message, direction);
        }
    }

    private final class MgcpCommandCallback
    implements FutureCallback<MgcpCommandResult> {
        private MgcpCommandCallback() {
        }

        public void onSuccess(MgcpCommandResult result) {
            MgcpResponse response = this.buildResponse(result);
            MgcpTransactionManager.this.notify(MgcpTransactionManager.this, response, MessageDirection.OUTGOING);
        }

        public void onFailure(Throwable t) {
            log.error((Object)"An error occurred processing an MGCP Command.", t);
        }

        private MgcpResponse buildResponse(MgcpCommandResult result) {
            MgcpResponse response = new MgcpResponse();
            response.setCode(result.getCode());
            response.setMessage(result.getMessage());
            response.setTransactionId(result.getTransactionId());
            Parameters<MgcpParameterType> parameters = result.getParameters();
            if (parameters.size() > 0) {
                for (MgcpParameterType key : parameters.keySet()) {
                    Optional<String> value = parameters.getString(key);
                    if (!value.isPresent()) continue;
                    response.addParameter(key, (String)value.get());
                }
            }
            return response;
        }
    }
}

