/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.connection.AbstractMgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionState;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptionType;
import org.mobicents.media.control.mgcp.message.LocalConnectionOptions;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpEventProvider;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.r.rto.RtpTimeoutEvent;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtp.CnameGenerator;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.channels.AudioChannel;
import org.mobicents.media.server.impl.rtp.channels.MediaChannel;
import org.mobicents.media.server.impl.rtp.channels.MediaChannelProvider;
import org.mobicents.media.server.impl.rtp.sdp.SdpFactory;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionDescriptionParser;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.spi.ConnectionMode;

public class MgcpRemoteConnection
extends AbstractMgcpConnection
implements RtpListener {
    private static final Logger log = Logger.getLogger(MgcpRemoteConnection.class);
    private final String localAddress;
    private final String externalAddress;
    private final String cname;
    private boolean outbound;
    private boolean webrtc;
    private SessionDescription localSdp;
    private SessionDescription remoteSdp;
    private final AudioChannel audioChannel;
    static final int HALF_OPEN_TIMER = 30;
    private final ListeningScheduledExecutorService executor;
    private ListenableFuture<?> timerFuture;
    private final int timeout;
    private final int halfOpenTimeout;

    public MgcpRemoteConnection(int identifier, int callId, int halfOpenTimeout, int openTimeout, MgcpEventProvider eventProvider, MediaChannelProvider channelProvider, ListeningScheduledExecutorService executor) {
        super(identifier, callId, eventProvider);
        this.localAddress = channelProvider.getLocalAddress();
        this.externalAddress = channelProvider.getExternalAddress();
        this.cname = CnameGenerator.generateCname();
        this.outbound = false;
        this.webrtc = false;
        this.localSdp = null;
        this.remoteSdp = null;
        this.audioChannel = channelProvider.provideAudioChannel();
        this.audioChannel.setCname(this.cname);
        this.executor = executor;
        this.timerFuture = null;
        this.halfOpenTimeout = halfOpenTimeout;
        this.timeout = openTimeout;
    }

    public MgcpRemoteConnection(int identifier, int callId, int timeout, MgcpEventProvider eventProvider, MediaChannelProvider channelProvider, ListeningScheduledExecutorService executor) {
        this(identifier, callId, 30, timeout, eventProvider, channelProvider, executor);
    }

    public MgcpRemoteConnection(int identifier, int callId, MgcpEventProvider eventProvider, MediaChannelProvider channelProvider, ListeningScheduledExecutorService executor) {
        this(identifier, callId, 0, eventProvider, channelProvider, executor);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void setMode(ConnectionMode mode) throws IllegalStateException {
        super.setMode(mode);
        this.audioChannel.setConnectionMode(mode);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection " + this.getHexIdentifier() + " mode is " + mode.name()));
        }
    }

    @Override
    public String halfOpen(LocalConnectionOptions options) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSED: {
                    this.state = MgcpConnectionState.HALF_OPEN;
                    String webrtcOption = options.get(LocalConnectionOptionType.WEBRTC);
                    this.outbound = true;
                    this.webrtc = webrtcOption != null && webrtcOption.equals("true");
                    this.audioChannel.open();
                    try {
                        this.audioChannel.bind(false, this.webrtc);
                    }
                    catch (IOException e) {
                        throw new MgcpConnectionException("Could not bind audio channel " + this.cname, e);
                    }
                    if (this.webrtc) {
                        this.audioChannel.enableICE(this.externalAddress, true);
                        this.audioChannel.enableDTLS();
                    }
                    this.localSdp = SdpFactory.buildSdp((boolean)true, (String)this.localAddress, (String)this.externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel});
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Connection " + this.getHexIdentifier() + " state is " + this.state.name()));
                    }
                    if (this.halfOpenTimeout > 0) {
                        this.timerFuture = this.executor.schedule((Runnable)new MgcpRemoteConnectionTimer(this.halfOpenTimeout), (long)this.halfOpenTimeout, TimeUnit.SECONDS);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Connection " + this.getHexIdentifier() + " initialized HALF_OPEN timer. Timeout in " + this.halfOpenTimeout + " seconds"));
                        }
                    }
                    return this.localSdp.toString();
                }
            }
            throw new MgcpConnectionException("Cannot half-open connection " + this.getHexIdentifier() + " because state is " + this.state.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String open(String sdp) throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSED: 
                case HALF_OPEN: {
                    this.state = MgcpConnectionState.OPEN;
                    try {
                        this.remoteSdp = SessionDescriptionParser.parse((String)sdp);
                    }
                    catch (SdpException e) {
                        throw new MgcpConnectionException(e.getMessage(), e);
                    }
                    this.openConnection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Connection " + this.getHexIdentifier() + " state is " + this.state.name()));
                    }
                    if (this.timerFuture != null && !this.timerFuture.isCancelled()) {
                        this.timerFuture.cancel(false);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Connection " + this.getHexIdentifier() + " canceled HALF_OPEN timer"));
                        }
                    }
                    if (this.timeout <= 0) break;
                    this.timerFuture = this.executor.schedule((Runnable)new MgcpRemoteConnectionTimer(this.timeout), (long)this.timeout, TimeUnit.SECONDS);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Connection " + this.getHexIdentifier() + " initialized OPEN timer. Timeout in " + this.timeout + " seconds"));
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot open connection " + this.getHexIdentifier() + " because state is " + this.state.name());
                }
            }
        }
        return this.localSdp.toString();
    }

    private void openConnection() throws MgcpConnectionException {
        this.audioChannel.open();
        try {
            if (this.outbound) {
                this.openOutboundConnection();
            } else {
                this.openInboundConnection();
            }
        }
        catch (IOException e) {
            throw new MgcpConnectionException(e.getMessage(), e);
        }
    }

    private void openInboundConnection() throws IOException {
        MediaDescriptionField remoteApplication;
        this.audioChannel.open();
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        this.setupAudioChannelInbound(remoteAudio);
        this.localSdp = SdpFactory.buildSdp((boolean)false, (String)this.localAddress, (String)this.externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel});
        MediaDescriptionField remoteVideo = this.remoteSdp.getMediaDescription("video");
        if (remoteVideo != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteVideo);
        }
        if ((remoteApplication = this.remoteSdp.getMediaDescription("application")) != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteApplication);
        }
    }

    private void setupAudioChannelInbound(MediaDescriptionField remoteAudio) throws IOException {
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        this.audioChannel.bind(false, remoteAudio.isRtcpMux());
        boolean enableIce = remoteAudio.containsIce();
        if (enableIce) {
            this.audioChannel.enableICE(this.externalAddress, remoteAudio.isRtcpMux());
        } else {
            String remoteAddr = remoteAudio.getConnection().getAddress();
            this.audioChannel.connectRtp(remoteAddr, remoteAudio.getPort());
            this.audioChannel.connectRtcp(remoteAddr, remoteAudio.getRtcpPort());
        }
        boolean enableDtls = this.remoteSdp.containsDtls();
        if (enableDtls) {
            FingerprintAttribute fingerprint = this.remoteSdp.getFingerprint(this.audioChannel.getMediaType());
            this.audioChannel.enableDTLS(fingerprint.getHashFunction(), fingerprint.getFingerprint());
        }
    }

    private void openOutboundConnection() throws IOException {
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        if (this.audioChannel.isDtlsEnabled()) {
            FingerprintAttribute fingerprint = remoteAudio.getFingerprint();
            this.audioChannel.setRemoteFingerprint(fingerprint.getHashFunction(), fingerprint.getFingerprint());
        }
        this.setupAudioChannelOutbound(remoteAudio);
    }

    private void setupAudioChannelOutbound(MediaDescriptionField remoteAudio) throws IOException {
        boolean connectNow;
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        String remoteRtpAddress = remoteAudio.getConnection().getAddress();
        int remoteRtpPort = remoteAudio.getPort();
        boolean bl = connectNow = !this.outbound || !this.audioChannel.isIceEnabled();
        if (connectNow) {
            this.audioChannel.connectRtp(remoteRtpAddress, remoteRtpPort);
            boolean remoteRtcpMux = remoteAudio.isRtcpMux();
            if (remoteRtcpMux) {
                this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort);
            } else {
                RtcpAttribute remoteRtcp = remoteAudio.getRtcp();
                if (remoteRtcp == null) {
                    this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort + 1);
                } else {
                    String remoteRtcpAddress = remoteRtcp.getAddress();
                    if (remoteRtcpAddress == null) {
                        remoteRtcpAddress = remoteRtpAddress;
                    }
                    int remoteRtcpPort = remoteRtcp.getPort();
                    this.audioChannel.connectRtcp(remoteRtcpAddress, remoteRtcpPort);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MgcpConnectionException {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case HALF_OPEN: 
                case OPEN: {
                    if (this.timerFuture != null) {
                        this.timerFuture.cancel(false);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Connection " + this.getHexIdentifier() + " canceled timer."));
                        }
                    }
                    this.setMode(ConnectionMode.INACTIVE);
                    this.state = MgcpConnectionState.CLOSED;
                    if (this.audioChannel.isOpen()) {
                        this.audioChannel.close();
                    }
                    this.reset();
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Connection " + this.getHexIdentifier() + " state is " + this.state.name()));
                    break;
                }
                default: {
                    throw new MgcpConnectionException("Cannot close connection " + this.getHexIdentifier() + "because state is " + this.state.name());
                }
            }
        }
    }

    @Override
    protected void listen(MgcpEvent event) {
        if (event instanceof RtpTimeoutEvent) {
            this.listen((RtpTimeoutEvent)event);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection " + this.getHexIdentifier() + " is listening to event " + event.toString()));
        }
    }

    private void listen(RtpTimeoutEvent timeoutEvent) {
    }

    @Override
    protected boolean isEventSupported(MgcpRequestedEvent event) {
        switch (event.getPackageName()) {
            case "R": {
                switch (event.getEventType()) {
                    case "rto": {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public AudioComponent getAudioComponent() {
        return this.audioChannel.getAudioComponent();
    }

    @Override
    public OOBComponent getOutOfBandComponent() {
        return this.audioChannel.getAudioOobComponent();
    }

    public void onRtpFailure(Throwable e) {
        String message = "RTP channel failure on connection " + this.cname + "!";
        if (e != null && e.getMessage() != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtpFailure(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRtpFailure(String message) {
        int timeoutValue = MgcpConnectionState.HALF_OPEN.equals((Object)this.state) ? this.halfOpenTimeout : this.timeout;
        try {
            this.close();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to elegantly close connection " + this.cname + " after RTP failure"), (Throwable)e);
        }
        finally {
            this.notify(this, new RtpTimeoutEvent(this.getIdentifier(), timeoutValue));
        }
    }

    protected void timeout(int elapsedTime) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Connection " + this.getHexIdentifier() + " timed out after " + elapsedTime + " seconds"));
        }
        try {
            this.close();
        }
        catch (MgcpConnectionException e) {
            log.warn((Object)("Could not close connection " + this.getHexIdentifier() + " in elegant manner after timeout."));
        }
        this.notify(this, new RtpTimeoutEvent(this.getIdentifier(), elapsedTime));
    }

    public void onRtcpFailure(Throwable e) {
        String message = "Closing RTCP channel on connection " + this.cname + " due to failure!";
        if (e != null && e.getMessage() != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtcpFailure(message);
    }

    public void onRtcpFailure(String e) {
        log.warn((Object)e);
    }

    private void reset() {
        this.outbound = false;
        this.webrtc = false;
        this.localSdp = null;
        this.remoteSdp = null;
    }

    @Override
    protected Logger log() {
        return log;
    }

    final class MgcpRemoteConnectionTimer
    implements Runnable {
        private final int timeout;

        public MgcpRemoteConnectionTimer(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public void run() {
            MgcpRemoteConnection.this.timeout(this.timeout);
        }
    }
}

