/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.call;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

public class MgcpCall {
    private static final Logger log = Logger.getLogger(MgcpCall.class);
    private final int callId;
    private final SetMultimap<String, Integer> entries;

    public MgcpCall(int callId) {
        this.callId = callId;
        this.entries = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create((int)3, (int)3));
    }

    public int getCallId() {
        return this.callId;
    }

    public String getCallIdHex() {
        return Integer.toHexString(this.callId).toUpperCase();
    }

    public Set<String> getEndpoints() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public Set<Integer> getConnections(String endpointId) {
        return Collections.unmodifiableSet(this.entries.get((Object)endpointId));
    }

    public boolean addConnection(String endpointId, int connectionId) {
        boolean added = this.entries.put((Object)endpointId, (Object)connectionId);
        if (added && log.isDebugEnabled()) {
            int left = this.entries.get((Object)endpointId).size();
            log.debug((Object)("Call " + this.getCallIdHex() + " registered connection " + Integer.toHexString(connectionId) + " at endpoint " + endpointId + ". Connection count: " + left));
        }
        return added;
    }

    public boolean removeConnection(String endpointId, int connectionId) {
        boolean removed = this.entries.remove((Object)endpointId, (Object)connectionId);
        if (removed && log.isDebugEnabled()) {
            int left = this.entries.get((Object)endpointId).size();
            log.debug((Object)("Call " + this.getCallIdHex() + " unregistered connection " + Integer.toHexString(connectionId) + " from endpoint " + endpointId + ". Connection count: " + left));
        }
        return removed;
    }

    public Set<Integer> removeConnections(String endpointId) {
        Set removed = this.entries.removeAll((Object)endpointId);
        if (!removed.isEmpty() && log.isDebugEnabled()) {
            log.debug((Object)("Call " + this.getCallIdHex() + " unregistered connections " + Arrays.toString(this.convertToHex(removed)) + " from endpoint " + endpointId));
        }
        return removed;
    }

    private String[] convertToHex(Collection<Integer> identifiers) {
        String[] converted = new String[identifiers.size()];
        int index = 0;
        for (int id : identifiers) {
            converted[index] = Integer.toHexString(id);
            ++index;
        }
        return converted;
    }
}

