/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.command;

import java.util.ArrayDeque;
import java.util.Queue;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpSignal;

public class NotificationRequest {
    private final int transactionId;
    private final String requestIdentifier;
    private final NotifiedEntity notifiedEntity;
    private final MgcpRequestedEvent[] requestedEvents;
    private final Queue<MgcpSignal> requestedSignals;

    public NotificationRequest(int transactionId, String requestIdentifier, NotifiedEntity notifiedEntity, MgcpRequestedEvent[] requestedEvents, MgcpSignal ... requestedSignals) {
        this.transactionId = transactionId;
        this.requestIdentifier = requestIdentifier;
        this.notifiedEntity = notifiedEntity;
        this.requestedEvents = requestedEvents;
        this.requestedSignals = new ArrayDeque<MgcpSignal>(requestedSignals.length);
        for (MgcpSignal signal : requestedSignals) {
            this.requestedSignals.add(signal);
        }
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public MgcpRequestedEvent[] getRequestedEvents() {
        return this.requestedEvents;
    }

    public MgcpSignal pollSignal() {
        return this.requestedSignals.poll();
    }

    public int countSignals() {
        return this.requestedSignals.size();
    }

    public boolean isListening(String event) {
        for (MgcpRequestedEvent evt : this.requestedEvents) {
            if (!evt.getQualifiedName().equalsIgnoreCase(event)) continue;
            return true;
        }
        return false;
    }
}

