/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.message;

import java.nio.ByteBuffer;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.util.collections.Parameters;

public abstract class MgcpMessage {
    protected int transactionId = -1;
    protected final Parameters<MgcpParameterType> parameters = new Parameters();
    protected final ByteBuffer data = ByteBuffer.allocate(8192);

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public boolean isSdpDetected() {
        return this.parameters.containsKey(MgcpParameterType.SDP);
    }

    public Parameters<MgcpParameterType> getParameters() {
        return this.parameters.clone();
    }

    public String getParameter(MgcpParameterType type) {
        return (String)this.parameters.getString(type).orNull();
    }

    public boolean hasParameter(MgcpParameterType type) {
        return this.parameters.containsKey(type);
    }

    public void addParameter(MgcpParameterType type, String value) {
        this.parameters.put(type, value);
    }

    public void removeParameter(MgcpParameterType type) {
        this.parameters.remove(type);
    }

    public void removeParameters() {
        this.parameters.clear();
    }

    public abstract boolean isRequest();

    public abstract String toString();
}

