/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.MgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandProvider;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.exception.DuplicateMgcpTransactionException;
import org.mobicents.media.control.mgcp.exception.MgcpTransactionNotFoundException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpResponse;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.network.MgcpChannel;
import org.mobicents.media.control.mgcp.transaction.MgcpTransactionManager;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.io.network.channel.NetworkChannel;
import org.mobicents.media.server.spi.ControlProtocol;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointInstaller;
import org.mobicents.media.server.spi.ServerManager;

public class MgcpController
implements ServerManager,
MgcpMessageObserver {
    private static final Logger log = Logger.getLogger(MgcpController.class);
    private final UdpManager networkManager;
    private final MgcpChannel channel;
    private final MgcpTransactionManager transactions;
    private final MgcpEndpointManager endpoints;
    private final MgcpCommandProvider commands;
    private final String address;
    private final int port;
    private boolean active;

    public MgcpController(String address, int port, UdpManager networkManager, MgcpChannel channel, MgcpTransactionManager transactions, MgcpEndpointManager endpoints, MgcpCommandProvider commands) {
        this.networkManager = networkManager;
        this.channel = channel;
        this.transactions = transactions;
        this.endpoints = endpoints;
        this.commands = commands;
        this.address = address;
        this.port = port;
        this.active = false;
    }

    public ControlProtocol getControlProtocol() {
        return ControlProtocol.MGPC;
    }

    public void activate() throws IllegalStateException {
        if (this.active) {
            throw new IllegalStateException("Controller is already active");
        }
        try {
            this.channel.open();
            this.channel.bind(new InetSocketAddress(this.address, this.port));
            if (log.isInfoEnabled()) {
                log.info((Object)("Opened MGCP channel at " + this.address + ":" + this.port));
            }
            this.networkManager.register((NetworkChannel)this.channel);
            this.channel.observe(this);
            this.transactions.observe(this);
            this.endpoints.observe(this);
            this.active = true;
            if (log.isInfoEnabled()) {
                log.info((Object)"MGCP controller is active");
            }
        }
        catch (IOException e) {
            log.error((Object)"An error occurred while activating the controller. Aborting.", (Throwable)e);
        }
    }

    public void deactivate() throws IllegalStateException {
        if (this.active) {
            this.channel.close();
            this.channel.forget(this);
            if (log.isInfoEnabled()) {
                log.info((Object)"MGCP channel is closed");
            }
            this.transactions.forget(this);
            this.endpoints.forget(this);
            this.active = false;
            if (log.isInfoEnabled()) {
                log.info((Object)"MGCP controller is inactive");
            }
        } else {
            throw new IllegalStateException("Controller is already inactive");
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void onStarted(Endpoint endpoint, EndpointInstaller installer) {
    }

    public void onStopped(Endpoint endpoint) {
    }

    @Override
    public void onMessage(InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        switch (direction) {
            case INCOMING: {
                if (message.isRequest()) {
                    this.onIncomingRequest(from, to, (MgcpRequest)message);
                    break;
                }
                this.onIncomingResponse(from, to, (MgcpResponse)message);
                break;
            }
            case OUTGOING: {
                if (message.isRequest()) {
                    this.onOutgoingRequest(from, to, (MgcpRequest)message);
                    break;
                }
                this.onOutgoingResponse(from, to, (MgcpResponse)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message direction: " + direction.name());
            }
        }
    }

    private void onIncomingRequest(InetSocketAddress from, InetSocketAddress to, MgcpRequest request) {
        MgcpCommand command = this.commands.provide(request.getRequestType(), request.getTransactionId(), request.getParameters());
        try {
            this.transactions.process(from, to, request, command, MessageDirection.INCOMING);
        }
        catch (DuplicateMgcpTransactionException e) {
            MgcpResponseCode provisional = MgcpResponseCode.TRANSACTION_BEING_EXECUTED;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received duplicate request tx=" + request.getTransactionId() + " from " + from.toString() + ". Sending provisional response with code " + provisional.code()));
            }
            try {
                this.sendResponse(to, request.getTransactionId(), provisional.code(), provisional.message());
            }
            catch (IOException e1) {
                log.error((Object)("Could not send provisional response to call agent, regarding transaction " + request.getTransactionId()), (Throwable)e);
            }
        }
    }

    private void onOutgoingRequest(InetSocketAddress from, InetSocketAddress to, MgcpRequest request) {
        try {
            this.transactions.process(from, to, request, null, MessageDirection.OUTGOING);
            this.channel.send(to, request);
        }
        catch (DuplicateMgcpTransactionException e) {
            log.error((Object)(e.getMessage() + ". Request wont' be sent to call agent."));
        }
        catch (IOException e) {
            log.error((Object)("Could not send MGCP request to call agent: " + request.toString()), (Throwable)e);
        }
    }

    private void onIncomingResponse(InetSocketAddress from, InetSocketAddress to, MgcpResponse response) {
        try {
            this.transactions.process(from, to, response, MessageDirection.INCOMING);
        }
        catch (MgcpTransactionNotFoundException e) {
            log.error((Object)e.getMessage());
        }
    }

    private void onOutgoingResponse(InetSocketAddress from, InetSocketAddress to, MgcpResponse response) {
        try {
            this.transactions.process(from, to, response, MessageDirection.OUTGOING);
            this.channel.send(to, response);
        }
        catch (MgcpTransactionNotFoundException e) {
            log.error((Object)(e.getMessage() + ". Response won't be sent to call agent."));
        }
        catch (IOException e) {
            log.error((Object)("Could not send MGCP response to call agent: " + response.toString()), (Throwable)e);
        }
    }

    private void sendResponse(InetSocketAddress to, int transactionId, int code, String message) throws IOException {
        MgcpResponse response = new MgcpResponse();
        response.setTransactionId(transactionId);
        response.setCode(code);
        response.setMessage(message);
        this.channel.send(to, response);
    }
}

