/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.endpoint;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointObserver;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointState;
import org.mobicents.media.control.mgcp.endpoint.provider.MgcpEndpointProvider;
import org.mobicents.media.control.mgcp.exception.MgcpEndpointNotFoundException;
import org.mobicents.media.control.mgcp.exception.UnrecognizedMgcpNamespaceException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpMessageSubject;

public class MgcpEndpointManager
implements MgcpEndpointObserver,
MgcpMessageObserver,
MgcpMessageSubject {
    private static final Logger log = Logger.getLogger(MgcpEndpointManager.class);
    private final ConcurrentHashMap<String, MgcpEndpointProvider<?>> providers;
    private final ConcurrentHashMap<String, MgcpEndpoint> endpoints = new ConcurrentHashMap(100);
    private final Collection<MgcpMessageObserver> observers;

    public MgcpEndpointManager() {
        this.providers = new ConcurrentHashMap(5);
        this.observers = new CopyOnWriteArrayList<MgcpMessageObserver>();
    }

    public void installProvider(MgcpEndpointProvider<?> provider) throws IllegalArgumentException {
        MgcpEndpointProvider<?> old = this.providers.putIfAbsent(provider.getNamespace(), provider);
        if (old != null) {
            throw new IllegalArgumentException("Provider for namespace " + provider.getNamespace() + "already exists.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Installed MGCP Endpoint Provider for namespace " + provider.getNamespace()));
        }
    }

    public void uninstallProvider(String namespace) {
        MgcpEndpointProvider<?> provider = this.providers.remove(namespace);
        if (provider != null && log.isInfoEnabled()) {
            log.info((Object)("Uninstalled MGCP Endpoint Provider for namespace " + provider.getNamespace()));
        }
    }

    public boolean supportsNamespace(String namespace) {
        return this.providers.containsKey(namespace);
    }

    public MgcpEndpoint registerEndpoint(String namespace) throws UnrecognizedMgcpNamespaceException {
        MgcpEndpointProvider<?> provider = this.providers.get(namespace);
        if (provider == null) {
            throw new UnrecognizedMgcpNamespaceException("Namespace " + namespace + " is unrecognized");
        }
        Object endpoint = provider.provide();
        endpoint.observe(this);
        endpoint.observe(this);
        this.endpoints.put(endpoint.getEndpointId().toString(), (MgcpEndpoint)endpoint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered endpoint " + endpoint.getEndpointId().toString() + ". Count: " + this.endpoints.size()));
        }
        return endpoint;
    }

    public MgcpEndpoint getEndpoint(String endpointId) {
        return this.endpoints.get(endpointId);
    }

    public void unregisterEndpoint(String endpointId) throws MgcpEndpointNotFoundException {
        MgcpEndpoint endpoint = this.endpoints.remove(endpointId);
        if (endpoint == null) {
            throw new MgcpEndpointNotFoundException("Endpoint " + endpointId + " not found");
        }
        endpoint.forget(this);
        endpoint.forget(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered endpoint " + endpoint.getEndpointId().toString() + ". Count: " + this.endpoints.size()));
        }
    }

    @Override
    public void onMessage(InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        this.notify(this, from, to, message, direction);
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }

    @Override
    public void onEndpointStateChanged(MgcpEndpoint endpoint, MgcpEndpointState state) {
        if (log.isTraceEnabled()) {
            log.debug((Object)("Endpoint " + endpoint.getEndpointId().toString() + " changed state to " + state.name()));
        }
        if (MgcpEndpointState.INACTIVE.equals((Object)state)) {
            String endpointId = endpoint.getEndpointId().toString();
            try {
                this.unregisterEndpoint(endpointId);
            }
            catch (MgcpEndpointNotFoundException e) {
                log.warn((Object)("Could not unregister endpoint " + endpointId + ": Not found."));
            }
        }
    }
}

