/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpEventObserver;
import org.mobicents.media.control.mgcp.pkg.MgcpSignal;
import org.mobicents.media.control.mgcp.pkg.SignalType;

public abstract class AbstractMgcpSignal
implements MgcpSignal {
    private final int requestId;
    private final String packageName;
    private final String symbol;
    private final SignalType type;
    private final NotifiedEntity notifiedEntity;
    private final Map<String, String> parameters;
    private final List<MgcpEventObserver> observers;
    protected final AtomicBoolean executing;

    public AbstractMgcpSignal(String packageName, String symbol, SignalType type, int requestId, NotifiedEntity notifiedEntity, Map<String, String> parameters) {
        this.packageName = packageName;
        this.symbol = symbol;
        this.type = type;
        this.requestId = requestId;
        this.parameters = parameters;
        this.observers = new CopyOnWriteArrayList<MgcpEventObserver>();
        this.executing = new AtomicBoolean(false);
        this.notifiedEntity = notifiedEntity;
    }

    public AbstractMgcpSignal(String packageName, String symbol, SignalType type, int requestId, Map<String, String> parameters) {
        this(packageName, symbol, type, requestId, null, parameters);
    }

    public AbstractMgcpSignal(String packageName, String symbol, SignalType type, int requestId, NotifiedEntity notifiedEntity) {
        this(packageName, symbol, type, requestId, notifiedEntity, Collections.emptyMap());
    }

    public AbstractMgcpSignal(String packageName, String symbol, SignalType type, int requestId) {
        this(packageName, symbol, type, requestId, null, Collections.emptyMap());
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getName() {
        return this.packageName + "/" + this.symbol;
    }

    @Override
    public SignalType getSignalType() {
        return this.type;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    protected abstract boolean isParameterSupported(String var1);

    @Override
    public boolean isExecuting() {
        return this.executing.get();
    }

    @Override
    public void observe(MgcpEventObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void forget(MgcpEventObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notify(Object originator, MgcpEvent event) {
        for (MgcpEventObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onEvent(originator, event);
        }
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && obj instanceof AbstractMgcpSignal) {
            AbstractMgcpSignal other = (AbstractMgcpSignal)obj;
            boolean bl = equals = this.packageName.equalsIgnoreCase(other.packageName) && this.symbol.equalsIgnoreCase(other.symbol) && this.type.equals((Object)other.type) && this.parameters.size() == other.parameters.size();
            if (equals) {
                for (String key : this.parameters.keySet()) {
                    if (this.parameters.get(key).equals(other.parameters.get(key))) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public String toString() {
        return this.packageName + "/" + this.symbol;
    }
}

