/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.transaction;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.MgcpCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommandResult;
import org.mobicents.media.control.mgcp.exception.DuplicateMgcpTransactionException;
import org.mobicents.media.control.mgcp.exception.MgcpTransactionNotFoundException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpResponse;
import org.mobicents.media.control.mgcp.message.MgcpResponseCode;
import org.mobicents.media.control.mgcp.transaction.MgcpTransaction;
import org.mobicents.media.control.mgcp.transaction.MgcpTransactionManager;
import org.mobicents.media.control.mgcp.transaction.MgcpTransactionNumberspace;
import org.mobicents.media.control.mgcp.util.collections.Parameters;

public class SubMgcpTransactionManager
implements MgcpTransactionManager {
    private static final Logger log = Logger.getLogger(SubMgcpTransactionManager.class);
    private final ListeningExecutorService executor;
    private final MgcpTransactionNumberspace numberspace;
    private final ConcurrentHashMap<Integer, MgcpTransaction> transactions;
    private final Collection<MgcpMessageObserver> observers;

    public SubMgcpTransactionManager(MgcpTransactionNumberspace numberspace, ListeningExecutorService executor) {
        this.executor = executor;
        this.numberspace = numberspace;
        this.transactions = new ConcurrentHashMap(500);
        this.observers = new CopyOnWriteArraySet<MgcpMessageObserver>();
    }

    private MgcpTransaction createTransaction(MgcpRequest request) throws DuplicateMgcpTransactionException {
        MgcpTransaction transaction;
        boolean local;
        int transactionId = request.getTransactionId();
        boolean bl = local = transactionId == 0;
        if (local) {
            transaction = new MgcpTransaction(this.numberspace.generateId());
            request.setTransactionId(transaction.getId());
            transactionId = transaction.getId();
        } else {
            transaction = new MgcpTransaction(transactionId);
        }
        MgcpTransaction old = this.transactions.putIfAbsent(transaction.getId(), transaction);
        if (old != null) {
            throw new DuplicateMgcpTransactionException("Transaction " + transactionId + " already exists.");
        }
        return transaction;
    }

    boolean contains(int transactionId) {
        return this.transactions.containsKey(transactionId);
    }

    @Override
    public void process(InetSocketAddress from, InetSocketAddress to, MgcpRequest request, MgcpCommand command, MessageDirection direction) throws DuplicateMgcpTransactionException {
        this.createTransaction(request);
        if (log.isDebugEnabled()) {
            String callAgent = MessageDirection.INCOMING.equals((Object)direction) ? from.toString() : to.toString();
            log.debug((Object)("Started transaction " + request.getTransactionId() + " for call agent " + callAgent));
        }
        if (command != null) {
            ListenableFuture future = this.executor.submit((Callable)command);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new MgcpCommandCallback(from, to, request.getTransactionId()));
        }
    }

    @Override
    public void process(InetSocketAddress from, InetSocketAddress to, MgcpResponse response, MessageDirection direction) throws MgcpTransactionNotFoundException {
        MgcpTransaction transaction = this.transactions.remove(response.getTransactionId());
        if (transaction == null) {
            throw new MgcpTransactionNotFoundException("Could not find transaction " + response.getTransactionId());
        }
        if (log.isDebugEnabled()) {
            String callAgent = MessageDirection.INCOMING.equals((Object)direction) ? from.toString() : to.toString();
            log.debug((Object)("Closed transaction " + response.getTransactionId() + " for call agent " + callAgent + " with code " + response.getCode()));
        }
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unregistered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }

    private final class MgcpCommandCallback
    implements FutureCallback<MgcpCommandResult> {
        private final InetSocketAddress from;
        private final InetSocketAddress to;
        private final int transactionId;

        public MgcpCommandCallback(InetSocketAddress from, InetSocketAddress to, int transactionId) {
            this.from = from;
            this.to = to;
            this.transactionId = transactionId;
        }

        public void onSuccess(MgcpCommandResult result) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("MGCP Command of transaction " + result.getTransactionId() + " executed successfully."));
            }
            MgcpResponse response = this.buildResponse(result);
            SubMgcpTransactionManager.this.notify(SubMgcpTransactionManager.this, this.to, this.from, response, MessageDirection.OUTGOING);
        }

        public void onFailure(Throwable t) {
            log.warn((Object)("MGCP Command of transaction " + this.transactionId + " failed. Replying with error code " + MgcpResponseCode.PROTOCOL_ERROR.code()), t);
            MgcpResponse response = this.buildResponse(MgcpResponseCode.PROTOCOL_ERROR);
            SubMgcpTransactionManager.this.notify(SubMgcpTransactionManager.this, this.to, this.from, response, MessageDirection.OUTGOING);
        }

        private MgcpResponse buildResponse(MgcpCommandResult result) {
            MgcpResponse response = new MgcpResponse();
            response.setCode(result.getCode());
            response.setMessage(result.getMessage());
            response.setTransactionId(result.getTransactionId());
            Parameters<MgcpParameterType> parameters = result.getParameters();
            if (parameters.size() > 0) {
                for (MgcpParameterType key : parameters.keySet()) {
                    Optional<String> value = parameters.getString(key);
                    if (!value.isPresent()) continue;
                    response.addParameter(key, (String)value.get());
                }
            }
            return response;
        }

        private MgcpResponse buildResponse(MgcpResponseCode code) {
            MgcpResponse response = new MgcpResponse();
            response.setCode(code.code());
            response.setMessage(code.message());
            response.setTransactionId(this.transactionId);
            return response;
        }
    }
}

