/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.control.mgcp.connection.MgcpLocalConnection;
import org.mobicents.media.control.mgcp.connection.MgcpRemoteConnection;
import org.mobicents.media.control.mgcp.pkg.MgcpEventProvider;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.channels.MediaChannelProvider;

public class MgcpConnectionProvider {
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private final int timeout;
    private final MediaChannelProvider channelProvider;
    private final ChannelsManager channelsManager;
    private final ListeningScheduledExecutorService executor;
    private final MgcpEventProvider eventProvider;

    public MgcpConnectionProvider(int timeout, MgcpEventProvider eventProvider, MediaChannelProvider channelProvider, ChannelsManager channelsManager, ListeningScheduledExecutorService executor) {
        this.timeout = timeout;
        this.eventProvider = eventProvider;
        this.channelProvider = channelProvider;
        this.channelsManager = channelsManager;
        this.executor = executor;
    }

    public MgcpRemoteConnection provideRemote(int callId) {
        return new MgcpRemoteConnection(this.idGenerator.incrementAndGet(), callId, this.timeout, this.eventProvider, this.channelProvider, this.executor);
    }

    public MgcpLocalConnection provideLocal(int callId) {
        return new MgcpLocalConnection(this.idGenerator.incrementAndGet(), callId, this.eventProvider, this.channelsManager);
    }
}

