/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg;

import org.mobicents.media.control.mgcp.pkg.MgcpActionType;

public class MgcpRequestedEvent {
    private static final String[] EMPTY_PARAMS = new String[0];
    private final int requestId;
    private final String packageName;
    private final String eventType;
    private final MgcpActionType action;
    private final int connectionId;
    private final String[] parameters;

    public MgcpRequestedEvent(int requestId, String packageName, String eventType, MgcpActionType action, int connectionId, String ... parameters) {
        this.requestId = requestId;
        this.packageName = packageName;
        this.eventType = eventType;
        this.action = action;
        this.connectionId = connectionId;
        this.parameters = parameters == null ? EMPTY_PARAMS : parameters;
    }

    public MgcpRequestedEvent(int requestId, String packageName, String eventType, MgcpActionType action) {
        this(requestId, packageName, eventType, action, 0, EMPTY_PARAMS);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getQualifiedName() {
        return this.packageName + "/" + this.eventType;
    }

    public MgcpActionType getAction() {
        return this.action;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.packageName).append("/").append(this.eventType);
        if (this.connectionId > 0) {
            builder.append("@").append(Integer.toHexString(this.connectionId));
        }
        builder.append("(").append((Object)this.action).append(")");
        if (this.parameters.length > 0) {
            builder.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                builder.append(this.parameters[i]);
                if (i >= this.parameters.length - 1) continue;
                builder.append(",");
            }
            builder.append(")");
        }
        return builder.toString();
    }
}

