/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.transaction;

import com.google.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.MgcpCommand;
import org.mobicents.media.control.mgcp.exception.DuplicateMgcpTransactionException;
import org.mobicents.media.control.mgcp.exception.MgcpTransactionNotFoundException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpResponse;
import org.mobicents.media.control.mgcp.transaction.MgcpTransactionManager;
import org.mobicents.media.control.mgcp.transaction.MgcpTransactionManagerProvider;

public class GlobalMgcpTransactionManager
implements MgcpTransactionManager,
MgcpMessageObserver {
    private static final Logger log = Logger.getLogger(GlobalMgcpTransactionManager.class);
    private final MgcpTransactionManagerProvider provider;
    private final ConcurrentHashMap<String, MgcpTransactionManager> managers;
    private final Set<MgcpMessageObserver> observers;

    public GlobalMgcpTransactionManager(MgcpTransactionManagerProvider provider) {
        this.provider = provider;
        this.managers = new ConcurrentHashMap();
        this.observers = Sets.newConcurrentHashSet();
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        boolean added = this.observers.add(observer);
        if (added && log.isTraceEnabled() && log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        boolean removed = this.observers.remove(observer);
        if (removed && log.isTraceEnabled() && log.isTraceEnabled()) {
            log.trace((Object)("Unregistered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }

    @Override
    public void onMessage(InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        this.notify(this, from, to, message, direction);
    }

    @Override
    public void process(InetSocketAddress from, InetSocketAddress to, MgcpRequest request, MgcpCommand command, MessageDirection direction) throws DuplicateMgcpTransactionException {
        String callAgent = MessageDirection.INCOMING.equals((Object)direction) ? from.toString() : to.toString();
        MgcpTransactionManager manager = this.managers.get(callAgent);
        if (manager == null) {
            MgcpTransactionManager newManager = this.provider.provide();
            MgcpTransactionManager oldManager = this.managers.putIfAbsent(callAgent, newManager);
            if (oldManager == null) {
                manager = newManager;
                manager.observe(this);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created new transaction manager to handle transactions for call agent " + callAgent));
                }
            } else {
                manager = oldManager;
            }
        }
        manager.process(from, to, request, command, direction);
    }

    @Override
    public void process(InetSocketAddress from, InetSocketAddress to, MgcpResponse response, MessageDirection direction) throws MgcpTransactionNotFoundException {
        String callAgent = MessageDirection.INCOMING.equals((Object)direction) ? from.toString() : to.toString();
        MgcpTransactionManager manager = this.managers.get(callAgent);
        if (manager == null) {
            MgcpTransactionManager newManager = this.provider.provide();
            MgcpTransactionManager oldManager = this.managers.putIfAbsent(callAgent, newManager);
            if (oldManager == null) {
                manager = newManager;
                manager.observe(this);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created new transaction manager to handle transactions for call agent " + callAgent));
                }
            } else {
                manager = oldManager;
            }
        }
        manager.process(from, to, response, direction);
    }
}

