/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.command;

import org.mobicents.media.control.mgcp.call.MgcpCallManager;
import org.mobicents.media.control.mgcp.command.AuditConnectionCommand;
import org.mobicents.media.control.mgcp.command.AuditEndpointCommand;
import org.mobicents.media.control.mgcp.command.CreateConnectionCommand;
import org.mobicents.media.control.mgcp.command.DeleteConnectionCommand;
import org.mobicents.media.control.mgcp.command.MgcpCommand;
import org.mobicents.media.control.mgcp.command.ModifyConnectionCommand;
import org.mobicents.media.control.mgcp.command.RequestNotificationCommand;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointManager;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpRequestType;
import org.mobicents.media.control.mgcp.pkg.MgcpPackageManager;
import org.mobicents.media.control.mgcp.pkg.MgcpSignalProvider;
import org.mobicents.media.control.mgcp.util.collections.Parameters;

public class MgcpCommandProvider {
    private final MgcpEndpointManager endpointManager;
    private final MgcpSignalProvider signalProvider;
    private final MgcpPackageManager packageManager;
    private final MgcpCallManager callManager;

    public MgcpCommandProvider(MgcpEndpointManager endpointManager, MgcpPackageManager packageManager, MgcpSignalProvider signalProvider, MgcpCallManager callManager) {
        this.endpointManager = endpointManager;
        this.packageManager = packageManager;
        this.signalProvider = signalProvider;
        this.callManager = callManager;
    }

    public MgcpCommand provide(MgcpRequestType type, int transactionId, Parameters<MgcpParameterType> parameters) {
        switch (type) {
            case CRCX: {
                return new CreateConnectionCommand(transactionId, parameters, this.endpointManager);
            }
            case MDCX: {
                return new ModifyConnectionCommand(transactionId, parameters, this.endpointManager);
            }
            case DLCX: {
                return new DeleteConnectionCommand(transactionId, parameters, this.endpointManager);
            }
            case RQNT: {
                return new RequestNotificationCommand(transactionId, parameters, this.endpointManager, this.packageManager, this.signalProvider);
            }
            case AUCX: {
                return new AuditConnectionCommand(transactionId, parameters, this.endpointManager);
            }
            case AUEP: {
                return new AuditEndpointCommand(transactionId, parameters, this.endpointManager);
            }
        }
        throw new IllegalArgumentException("Unsupported command type " + type.name());
    }
}

