/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.connection;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionState;
import org.mobicents.media.control.mgcp.exception.MalformedMgcpEventRequestException;
import org.mobicents.media.control.mgcp.exception.MgcpEventNotFoundException;
import org.mobicents.media.control.mgcp.exception.MgcpPackageNotFoundException;
import org.mobicents.media.control.mgcp.exception.UnsupportedMgcpEventException;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpEventObserver;
import org.mobicents.media.control.mgcp.pkg.MgcpEventProvider;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.spi.ConnectionMode;

public abstract class AbstractMgcpConnection
implements MgcpConnection {
    private final int identifier;
    private final int callIdentifier;
    private ConnectionMode mode;
    protected volatile MgcpConnectionState state;
    protected final Object stateLock;
    private final MgcpEventProvider eventProvider;
    protected final Set<MgcpEventObserver> observers;

    public AbstractMgcpConnection(int identifier, int callId, MgcpEventProvider eventProvider) {
        this.identifier = identifier;
        this.callIdentifier = callId;
        this.mode = ConnectionMode.INACTIVE;
        this.state = MgcpConnectionState.CLOSED;
        this.stateLock = new Object();
        this.eventProvider = eventProvider;
        this.observers = Sets.newConcurrentHashSet();
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getHexIdentifier() {
        return Integer.toHexString(this.identifier).toUpperCase();
    }

    @Override
    public int getCallIdentifier() {
        return this.callIdentifier;
    }

    @Override
    public String getCallIdentifierHex() {
        return Integer.toHexString(this.callIdentifier).toUpperCase();
    }

    @Override
    public ConnectionMode getMode() {
        return this.mode;
    }

    @Override
    public MgcpConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(ConnectionMode mode) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (MgcpConnectionState.CLOSED.equals((Object)this.state)) {
                throw new IllegalStateException("Cannot update mode because connection is closed.");
            }
        }
        this.mode = mode;
    }

    @Override
    public void listen(MgcpRequestedEvent event) throws UnsupportedMgcpEventException {
        if (this.isEventSupported(event)) {
            try {
                MgcpEvent mgcpEvent = this.eventProvider.provide(event);
                this.listen(mgcpEvent);
            }
            catch (MalformedMgcpEventRequestException | MgcpEventNotFoundException | MgcpPackageNotFoundException e) {
                throw new UnsupportedMgcpEventException("MGCP Event " + event.toString() + " is not supported.", e);
            }
        } else {
            throw new UnsupportedMgcpEventException("Connection " + this.getCallIdentifierHex() + " does not support event " + event.getQualifiedName());
        }
    }

    protected abstract boolean isEventSupported(MgcpRequestedEvent var1);

    protected abstract void listen(MgcpEvent var1) throws UnsupportedMgcpEventException;

    @Override
    public abstract AudioComponent getAudioComponent();

    @Override
    public abstract OOBComponent getOutOfBandComponent();

    @Override
    public void observe(MgcpEventObserver observer) {
        boolean added = this.observers.add(observer);
        if (added && this.log().isTraceEnabled()) {
            this.log().trace((Object)("Connection " + this.getHexIdentifier() + " registered MgcpEventObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpEventObserver observer) {
        boolean removed = this.observers.remove(observer);
        if (removed && this.log().isTraceEnabled()) {
            this.log().trace((Object)("Connection " + this.getHexIdentifier() + " unregistered MgcpEventObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, MgcpEvent event) {
        for (MgcpEventObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onEvent(originator, event);
        }
    }

    protected abstract Logger log();
}

