/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.endpoint;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.command.NotificationRequest;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;
import org.mobicents.media.control.mgcp.connection.AbstractMgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionProvider;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionState;
import org.mobicents.media.control.mgcp.endpoint.EndpointIdentifier;
import org.mobicents.media.control.mgcp.endpoint.MediaGroup;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointObserver;
import org.mobicents.media.control.mgcp.endpoint.MgcpEndpointState;
import org.mobicents.media.control.mgcp.exception.MgcpCallNotFoundException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionException;
import org.mobicents.media.control.mgcp.exception.MgcpConnectionNotFoundException;
import org.mobicents.media.control.mgcp.exception.UnsupportedMgcpEventException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpParameterType;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpRequestType;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpSignal;
import org.mobicents.media.control.mgcp.pkg.SignalType;

public class GenericMgcpEndpoint
implements MgcpEndpoint {
    private static final Logger log = Logger.getLogger(GenericMgcpEndpoint.class);
    private static final MgcpRequestedEvent[] EMPTY_ENDPOINT_EVENTS = new MgcpRequestedEvent[0];
    private final MgcpConnectionProvider connectionProvider;
    protected final MediaGroup mediaGroup;
    private final EndpointIdentifier endpointId;
    private final ConcurrentHashMap<Integer, MgcpConnection> connections;
    private final AtomicBoolean active;
    private NotifiedEntity notifiedEntity;
    private ConcurrentHashMap<String, MgcpSignal> signals;
    private MgcpRequestedEvent[] requestedEndpointEvents;
    private final Multimap<Integer, MgcpRequestedEvent> requestedConnectionEvents;
    private final Set<MgcpEndpointObserver> endpointObservers;
    private final Set<MgcpMessageObserver> messageObservers;

    public GenericMgcpEndpoint(EndpointIdentifier endpointId, MgcpConnectionProvider connectionProvider, MediaGroup mediaGroup) {
        this.connectionProvider = connectionProvider;
        this.endpointId = endpointId;
        this.connections = new ConcurrentHashMap(5);
        this.active = new AtomicBoolean(false);
        this.mediaGroup = mediaGroup;
        this.notifiedEntity = new NotifiedEntity();
        this.signals = new ConcurrentHashMap(5);
        this.requestedEndpointEvents = EMPTY_ENDPOINT_EVENTS;
        this.requestedConnectionEvents = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        this.endpointObservers = Sets.newConcurrentHashSet();
        this.messageObservers = Sets.newConcurrentHashSet();
    }

    @Override
    public EndpointIdentifier getEndpointId() {
        return this.endpointId;
    }

    @Override
    public MediaGroup getMediaGroup() {
        return this.mediaGroup;
    }

    public boolean hasConnections() {
        return !this.connections.isEmpty();
    }

    @Override
    public MgcpConnection getConnection(int callId, int connectionId) {
        MgcpConnection connection = this.connections.get(connectionId);
        if (connection != null && connection.getCallIdentifier() == callId) {
            return connection;
        }
        return null;
    }

    private boolean registerConnection(int callId, MgcpConnection connection) {
        boolean registered;
        MgcpConnection old = this.connections.putIfAbsent(connection.getIdentifier(), connection);
        boolean bl = registered = old == null;
        if (registered) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint " + this.endpointId.toString() + " registered connection " + connection.getHexIdentifier() + " to call " + connection.getCallIdentifierHex()));
            }
            connection.observe(this);
            this.onConnectionCreated(connection);
            if (!this.isActive()) {
                this.activate();
            }
        }
        return registered;
    }

    @Override
    public MgcpConnection createConnection(int callId, boolean local) {
        AbstractMgcpConnection connection = local ? this.connectionProvider.provideLocal(callId) : this.connectionProvider.provideRemote(callId);
        this.registerConnection(callId, connection);
        if (!connection.isLocal()) {
            connection.observe(this);
        }
        return connection;
    }

    @Override
    public MgcpConnection deleteConnection(int callId, int connectionId) throws MgcpCallNotFoundException, MgcpConnectionNotFoundException {
        MgcpConnection connection = this.connections.get(connectionId);
        if (connection == null) {
            throw new MgcpConnectionNotFoundException(this.endpointId + " could not find connection " + Integer.toHexString(connectionId).toUpperCase() + " in call " + Integer.toHexString(callId).toUpperCase());
        }
        if (connection.getCallIdentifier() != callId) {
            throw new MgcpCallNotFoundException(this.endpointId + " could not find connection " + Integer.toHexString(connectionId).toUpperCase() + " in call " + Integer.toHexString(callId).toUpperCase());
        }
        connection = this.connections.remove(connectionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint " + this.endpointId + " unregistered connection " + connection.getHexIdentifier() + " from call " + connection.getCallIdentifierHex()));
        }
        this.onConnectionDeleted(connection);
        if (!this.hasConnections() && this.isActive()) {
            this.deactivate();
        }
        try {
            connection.forget(this);
            if (!MgcpConnectionState.CLOSED.equals((Object)connection.getState())) {
                connection.close();
            }
        }
        catch (MgcpConnectionException e) {
            log.warn((Object)(this.endpointId + " could not close connection " + connection.getHexIdentifier() + " in elegant manner."), (Throwable)e);
        }
        return connection;
    }

    @Override
    public List<MgcpConnection> deleteConnections(int callId) throws MgcpCallNotFoundException {
        Collection<MgcpConnection> current = this.connections.values();
        ArrayList<MgcpConnection> deleted = new ArrayList<MgcpConnection>(current.size());
        for (MgcpConnection connection : current) {
            MgcpConnection removed;
            if (connection.getCallIdentifier() != callId || (removed = this.connections.remove(connection.getIdentifier())) == null) continue;
            deleted.add(removed);
        }
        if (deleted.size() == 0) {
            throw new MgcpCallNotFoundException(this.endpointId + " could not find call " + Integer.toHexString(callId).toUpperCase());
        }
        if (log.isDebugEnabled()) {
            String hexIdentifiers = Arrays.toString(this.getConnectionHexId(deleted));
            log.debug((Object)("Endpoint " + this.endpointId.toString() + " deleted " + deleted.size() + " connections from call " + callId + ": " + hexIdentifiers + ". Connection count: " + this.connections.size()));
        }
        if (!this.hasConnections() && this.isActive()) {
            this.deactivate();
        }
        return deleted;
    }

    @Override
    public List<MgcpConnection> deleteConnections() {
        Set keys = this.connections.keySet();
        ArrayList<MgcpConnection> deleted = new ArrayList<MgcpConnection>(keys.size());
        for (Integer key : keys) {
            MgcpConnection connection = this.connections.remove(key);
            if (connection == null) continue;
            try {
                connection.forget(this);
                if (!MgcpConnectionState.CLOSED.equals((Object)connection.getState())) {
                    connection.close();
                }
            }
            catch (MgcpConnectionException e) {
                log.warn((Object)(this.endpointId + " could not close connection " + connection.getHexIdentifier() + " in elegant manner."), (Throwable)e);
            }
            deleted.add(connection);
        }
        if (log.isDebugEnabled()) {
            String hexIdentifiers = Arrays.toString(this.getConnectionHexId(deleted));
            log.debug((Object)("Endpoint " + this.endpointId.toString() + " deleted " + deleted.size() + " connections: " + hexIdentifiers + ". Connection count: " + this.connections.size()));
        }
        if (!this.hasConnections() && this.isActive()) {
            this.deactivate();
        }
        return deleted;
    }

    private String[] getConnectionHexId(Collection<MgcpConnection> connections) {
        String[] hex = new String[connections.size()];
        int index = 0;
        for (MgcpConnection connection : connections) {
            hex[index] = connection.getHexIdentifier();
            ++index;
        }
        return hex;
    }

    public boolean isActive() {
        return this.active.get();
    }

    private void activate() throws IllegalStateException {
        if (this.active.get()) {
            throw new IllegalArgumentException("Endpoint " + this.endpointId + " is already active.");
        }
        this.active.set(true);
        this.onActivated();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint " + this.endpointId.toString() + " is active."));
        }
        this.notify(this, MgcpEndpointState.ACTIVE);
    }

    protected void deactivate() throws IllegalStateException {
        if (this.active.get()) {
            this.active.set(false);
            this.onDeactivated();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint " + this.endpointId.toString() + " is inactive."));
            }
        } else {
            throw new IllegalArgumentException("Endpoint " + this.endpointId + " is already inactive.");
        }
        this.notify(this, MgcpEndpointState.INACTIVE);
    }

    @Override
    public synchronized void requestNotification(NotificationRequest request) {
        if (request.getNotifiedEntity() != null) {
            this.notifiedEntity = request.getNotifiedEntity();
        }
        this.requestedEndpointEvents = EMPTY_ENDPOINT_EVENTS;
        this.requestedConnectionEvents.clear();
        int eventCount = request.getRequestedEvents().length;
        ArrayList<MgcpRequestedEvent> endpointEvents = new ArrayList<MgcpRequestedEvent>(eventCount);
        for (MgcpRequestedEvent requestedEvent : request.getRequestedEvents()) {
            if (requestedEvent.getConnectionId() > 0) {
                int connectionId = requestedEvent.getConnectionId();
                MgcpConnection connection = this.connections.get(connectionId);
                if (connection == null) {
                    log.warn((Object)("Requested event " + requestedEvent.toString() + " was dropped because connection " + Integer.toHexString(connectionId) + "was not found."));
                    continue;
                }
                try {
                    connection.listen(requestedEvent);
                    this.requestedConnectionEvents.put((Object)connectionId, (Object)requestedEvent);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Endpoint " + this.endpointId + " requested event " + requestedEvent.getQualifiedName() + " to connection " + requestedEvent.getConnectionId()));
                }
                catch (UnsupportedMgcpEventException e) {
                    log.warn((Object)("Requested event " + requestedEvent.toString() + " was dropped because it was not supported by connection " + connection.getHexIdentifier()), (Throwable)e);
                }
                continue;
            }
            endpointEvents.add(requestedEvent);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Endpoint " + this.endpointId + " is listening for event " + requestedEvent.getQualifiedName()));
        }
        if (endpointEvents.size() > 0) {
            this.requestedEndpointEvents = endpointEvents.toArray(new MgcpRequestedEvent[endpointEvents.size()]);
        }
        if (request.countSignals() == 0) {
            Iterator keys = this.signals.keySet().iterator();
            while (keys.hasNext()) {
                MgcpSignal ongoing = this.signals.get(keys.next());
                if (ongoing == null) continue;
                ongoing.cancel();
            }
        } else {
            ArrayList<String> retained = new ArrayList<String>(request.countSignals());
            MgcpSignal signal = request.pollSignal();
            while (signal != null) {
                SignalType signalType = signal.getSignalType();
                switch (signalType) {
                    case TIME_OUT: {
                        String signalName = signal.getName();
                        retained.add(signalName);
                        MgcpSignal original = this.signals.putIfAbsent(signalName, signal);
                        if (original != null) break;
                        signal.observe(this);
                        signal.execute();
                        break;
                    }
                    case BRIEF: {
                        signal.execute();
                        break;
                    }
                    default: {
                        log.warn((Object)("Dropping signal " + signal.toString() + " on endpoint " + this.getEndpointId().toString() + " because signal type " + (Object)((Object)signalType) + "is not supported."));
                    }
                }
                signal = request.pollSignal();
            }
            for (String key : this.signals.keySet()) {
                if (retained.contains(key)) continue;
                this.cancelSignal(key);
            }
        }
    }

    @Override
    public void cancelSignal(String signal) {
        MgcpSignal ongoing = this.signals.get(signal);
        if (ongoing != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Canceling signal " + ongoing.toString() + " on endpoint " + this.getEndpointId().toString()));
            }
            ongoing.cancel();
        }
    }

    protected void onConnectionCreated(MgcpConnection connection) {
    }

    protected void onConnectionDeleted(MgcpConnection connection) {
    }

    protected void onActivated() {
    }

    protected void onDeactivated() {
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.messageObservers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Endpoint " + this.endpointId.toString() + " registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.messageObservers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.messageObservers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Endpoint " + this.endpointId.toString() + " unregistered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.messageObservers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.messageObservers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }

    @Override
    public void onEvent(Object originator, MgcpEvent event) {
        MgcpRequest request = null;
        if (originator instanceof MgcpSignal) {
            request = this.onEndpointEvent((MgcpSignal)originator, event);
        } else if (originator instanceof MgcpConnection) {
            request = this.onConnectionEvent((MgcpConnection)originator, event);
        }
        if (request != null) {
            InetSocketAddress from = new InetSocketAddress(this.endpointId.getDomainName(), 2427);
            InetSocketAddress to = new InetSocketAddress(this.notifiedEntity.getDomain(), this.notifiedEntity.getPort());
            this.notify(this, from, to, request, MessageDirection.OUTGOING);
        }
    }

    private MgcpRequest onEndpointEvent(MgcpSignal signal, MgcpEvent event) {
        String composedName = event.getPackage() + "/" + event.getSymbol();
        if (this.isListening(composedName)) {
            this.signals.remove(signal.getName());
            MgcpRequest notify = new MgcpRequest();
            notify.setRequestType(MgcpRequestType.NTFY);
            notify.setTransactionId(0);
            notify.setEndpointId(this.endpointId.toString());
            NotifiedEntity entity = signal.getNotifiedEntity();
            if (entity != null) {
                notify.addParameter(MgcpParameterType.NOTIFIED_ENTITY, this.notifiedEntity.toString());
            }
            notify.addParameter(MgcpParameterType.OBSERVED_EVENT, event.toString());
            notify.addParameter(MgcpParameterType.REQUEST_ID, Integer.toString(signal.getRequestId(), 16));
            return notify;
        }
        return null;
    }

    private MgcpRequest onConnectionEvent(MgcpConnection connection, MgcpEvent event) {
        boolean removed;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.endpointId + " received MGCP event " + event.toString() + " from connection " + connection.getHexIdentifier()));
        }
        String composedName = event.getPackage() + "/" + event.getSymbol();
        int connectionId = connection.getIdentifier();
        MgcpRequestedEvent requestedEvent = this.isListening(connectionId, composedName);
        if (requestedEvent != null && (removed = this.requestedConnectionEvents.remove((Object)connectionId, (Object)requestedEvent))) {
            MgcpRequest notify = new MgcpRequest();
            notify.setRequestType(MgcpRequestType.NTFY);
            notify.setTransactionId(0);
            notify.setEndpointId(this.endpointId.toString());
            notify.addParameter(MgcpParameterType.OBSERVED_EVENT, event.toString());
            notify.addParameter(MgcpParameterType.REQUEST_ID, String.valueOf(requestedEvent.getRequestId()));
            return notify;
        }
        return null;
    }

    @Override
    public void observe(MgcpEndpointObserver observer) {
        this.endpointObservers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpEndpointObserver@" + observer.hashCode() + ". Count: " + this.endpointObservers.size()));
        }
    }

    @Override
    public void forget(MgcpEndpointObserver observer) {
        this.endpointObservers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unregistered MgcpEndpointObserver@" + observer.hashCode() + ". Count: " + this.endpointObservers.size()));
        }
    }

    @Override
    public void notify(MgcpEndpoint endpoint, MgcpEndpointState state) {
        for (MgcpEndpointObserver observer : this.endpointObservers) {
            observer.onEndpointStateChanged(this, state);
        }
    }

    private boolean isListening(String event) {
        for (MgcpRequestedEvent evt : this.requestedEndpointEvents) {
            if (!evt.getQualifiedName().equalsIgnoreCase(event)) continue;
            return true;
        }
        return false;
    }

    private MgcpRequestedEvent isListening(int connectionId, String event) {
        Collection events = this.requestedConnectionEvents.get((Object)connectionId);
        for (MgcpRequestedEvent evt : events) {
            if (!evt.getQualifiedName().equalsIgnoreCase(event)) continue;
            return evt;
        }
        return null;
    }
}

