/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.endpoint;

import org.mobicents.media.control.mgcp.connection.MgcpConnection;
import org.mobicents.media.control.mgcp.connection.MgcpConnectionProvider;
import org.mobicents.media.control.mgcp.endpoint.EndpointIdentifier;
import org.mobicents.media.control.mgcp.endpoint.GenericMgcpEndpoint;
import org.mobicents.media.control.mgcp.endpoint.MediaGroup;
import org.mobicents.media.server.component.audio.AudioSplitter;
import org.mobicents.media.server.component.oob.OOBSplitter;

public class MgcpSplitterEndpoint
extends GenericMgcpEndpoint {
    private final AudioSplitter inbandSplitter;
    private final OOBSplitter outbandSplitter;

    public MgcpSplitterEndpoint(EndpointIdentifier endpointId, AudioSplitter inbandSplitter, OOBSplitter outbandSplitter, MgcpConnectionProvider connectionProvider, MediaGroup mediaGroup) {
        super(endpointId, connectionProvider, mediaGroup);
        this.inbandSplitter = inbandSplitter;
        this.outbandSplitter = outbandSplitter;
    }

    @Override
    protected void onConnectionCreated(MgcpConnection connection) {
        if (connection.isLocal()) {
            this.inbandSplitter.addInsideComponent(connection.getAudioComponent());
            this.outbandSplitter.addInsideComponent(connection.getOutOfBandComponent());
        } else {
            this.inbandSplitter.addOutsideComponent(connection.getAudioComponent());
            this.outbandSplitter.addOutsideComponent(connection.getOutOfBandComponent());
        }
    }

    @Override
    protected void onConnectionDeleted(MgcpConnection connection) {
        if (connection.isLocal()) {
            this.inbandSplitter.releaseInsideComponent(connection.getAudioComponent());
            this.outbandSplitter.releaseInsideComponent(connection.getOutOfBandComponent());
        } else {
            this.inbandSplitter.releaseOutsideComponent(connection.getAudioComponent());
            this.outbandSplitter.releaseOutsideComponent(connection.getOutOfBandComponent());
        }
    }

    @Override
    protected void onActivated() {
        this.inbandSplitter.start();
        this.outbandSplitter.start();
    }

    @Override
    protected void onDeactivated() {
        this.inbandSplitter.stop();
        this.outbandSplitter.stop();
    }
}

