/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.network;

import com.google.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.exception.MgcpParseException;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpMessageParser;
import org.mobicents.media.control.mgcp.message.MgcpMessageSubject;
import org.mobicents.media.control.mgcp.message.MgcpRequest;
import org.mobicents.media.control.mgcp.message.MgcpResponse;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;

public class MgcpPacketHandler
implements PacketHandler,
MgcpMessageSubject {
    private static final Logger log = Logger.getLogger(MgcpPacketHandler.class);
    private final MgcpMessageParser parser;
    private final Set<MgcpMessageObserver> observers;

    public MgcpPacketHandler(MgcpMessageParser parser) {
        this.parser = parser;
        this.observers = Sets.newConcurrentHashSet();
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        return true;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        byte b = packet[0];
        MgcpMessage message = b >= 48 && b <= 57 ? this.handleResponse(packet, dataLength, offset, localPeer, remotePeer) : this.handleRequest(packet, dataLength, offset, localPeer, remotePeer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Incoming MGCP message from " + remotePeer.toString() + ":\n\n" + message.toString() + "\n"));
        }
        this.notify(this, remotePeer, localPeer, message, MessageDirection.INCOMING);
        return null;
    }

    private MgcpRequest handleRequest(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        try {
            return this.parser.parseRequest(packet, offset, dataLength);
        }
        catch (MgcpParseException e) {
            throw new PacketHandlerException((Throwable)e);
        }
    }

    private MgcpResponse handleResponse(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        try {
            return this.parser.parseResponse(packet, offset, dataLength);
        }
        catch (MgcpParseException e) {
            throw new PacketHandlerException((Throwable)e);
        }
    }

    public int getPipelinePriority() {
        return 0;
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }
}

