/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg;

import org.mobicents.media.control.mgcp.exception.MgcpParseException;
import org.mobicents.media.control.mgcp.pkg.SignalRequest;

public class SignalsRequestParser {
    private static final String NAMESPACE_SEPARATOR = "/";
    private static final String START_PARAM_SEPARATOR = "(";
    private static final String END_PARAM_SEPARATOR = ")";
    private static final String PARAM_SEPARATOR = " ";
    private static final String VALUE_SEPARATOR = "=";

    public static SignalRequest[] parse(String request) throws MgcpParseException {
        String[] signals = request.split("\\),");
        SignalRequest[] signalRequests = new SignalRequest[signals.length];
        for (int i = 0; i < signals.length; ++i) {
            signalRequests[i] = SignalsRequestParser.parseSingle(signals[i].trim() + END_PARAM_SEPARATOR);
        }
        return signalRequests;
    }

    private static SignalRequest parseSingle(String request) throws MgcpParseException {
        try {
            int indexOfNamespace = request.indexOf(NAMESPACE_SEPARATOR);
            int indexOfStartParam = request.indexOf(START_PARAM_SEPARATOR);
            int indexOfEndParam = request.indexOf(END_PARAM_SEPARATOR);
            if (indexOfNamespace == -1 || indexOfStartParam == -1 || indexOfEndParam == -1) {
                throw new IllegalArgumentException("Missing separator");
            }
            String packageName = request.substring(0, indexOfNamespace);
            String signalType = request.substring(indexOfNamespace + 1, indexOfStartParam);
            String[] parameters = request.substring(indexOfStartParam + 1, indexOfEndParam).split(PARAM_SEPARATOR);
            if (parameters.length == 0) {
                throw new IllegalArgumentException("Signal Request parameters missing.");
            }
            SignalRequest obj = new SignalRequest(packageName, signalType);
            for (String param : parameters) {
                int indexOfValue = param.indexOf(VALUE_SEPARATOR);
                if (indexOfValue == -1) {
                    throw new IllegalArgumentException("Value is missing separator.");
                }
                String key = param.substring(0, indexOfValue);
                String value = param.substring(indexOfValue + 1);
                obj.addParameter(key, value);
            }
            return obj;
        }
        catch (Exception e) {
            throw new MgcpParseException("Malformed signal request: " + request, e);
        }
    }
}

