/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg.au;

public class Playlist {
    private final String[] segments;
    private final int segmentCount;
    private final int iterations;
    private int index;
    private int counter;

    public Playlist(String[] segments, int iterations) {
        this.segments = segments;
        this.segmentCount = segments.length;
        this.iterations = iterations;
        this.index = -1;
        this.counter = iterations == -1 ? Integer.MAX_VALUE : iterations * this.segmentCount;
    }

    public String current() {
        return this.segments[this.index % this.segmentCount];
    }

    public boolean isOngoing() {
        return this.index != -1;
    }

    public boolean isEmpty() {
        return this.segmentCount == 0;
    }

    public String next() {
        if (this.isEmpty()) {
            return "";
        }
        --this.counter;
        ++this.index;
        return this.counter == -1 ? "" : this.segments[this.index % this.segmentCount];
    }

    public void rewind() {
        this.index = -1;
        this.counter = this.iterations == -1 ? Integer.MAX_VALUE : this.iterations * this.segmentCount;
    }
}

