/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg.au.pr;

import java.util.Map;
import org.mobicents.media.control.mgcp.command.param.NotifiedEntity;
import org.mobicents.media.control.mgcp.pkg.AbstractMgcpSignal;
import org.mobicents.media.control.mgcp.pkg.SignalType;
import org.mobicents.media.control.mgcp.pkg.au.SignalParameters;
import org.mobicents.media.control.mgcp.pkg.au.pr.PlayRecordContext;
import org.mobicents.media.control.mgcp.pkg.au.pr.PlayRecordEvent;
import org.mobicents.media.control.mgcp.pkg.au.pr.PlayRecordFsm;
import org.mobicents.media.control.mgcp.pkg.au.pr.PlayRecordFsmBuilder;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.dtmf.DtmfEvent;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.spi.recorder.Recorder;
import org.mobicents.media.server.spi.recorder.RecorderEvent;
import org.mobicents.media.server.spi.recorder.RecorderListener;

public class PlayRecord
extends AbstractMgcpSignal {
    static final String SYMBOL = "pr";
    private final PlayRecordFsm fsm;
    private final Player player;
    final PlayerListener playerListener;
    private final DtmfDetector detector;
    final DtmfDetectorListener detectorListener;
    private final Recorder recorder;
    final RecorderListener recorderListener;
    private final PlayRecordContext context;

    public PlayRecord(Player player, DtmfDetector detector, Recorder recorder, int requestId, NotifiedEntity notifiedEntity, Map<String, String> parameters) {
        super("AU", SYMBOL, SignalType.TIME_OUT, requestId, notifiedEntity, parameters);
        this.player = player;
        this.playerListener = new AudioPlayerListener();
        this.detector = detector;
        this.detectorListener = new DetectorListener();
        this.recorder = recorder;
        this.recorderListener = new AudioRecorderListener();
        this.context = new PlayRecordContext(parameters);
        this.fsm = PlayRecordFsmBuilder.INSTANCE.build(this, recorder, this.recorderListener, detector, this.detectorListener, player, this.playerListener, this.context);
    }

    public PlayRecord(Player player, DtmfDetector detector, Recorder recorder, int requestId, Map<String, String> parameters) {
        this(player, detector, recorder, requestId, null, parameters);
    }

    @Override
    public void execute() {
        if (!this.fsm.isStarted()) {
            this.fsm.start(this.context);
        }
    }

    @Override
    public void cancel() {
        if (this.fsm.isStarted()) {
            this.fsm.fire((Object)PlayRecordEvent.CANCEL, this.context);
        }
    }

    @Override
    protected boolean isParameterSupported(String name) {
        SignalParameters parameter = SignalParameters.fromSymbol(name);
        if (parameter == null) {
            return false;
        }
        switch (parameter) {
            case INITIAL_PROMPT: 
            case REPROMPT: 
            case NO_SPEECH_REPROMTP: 
            case FAILURE_ANNOUNCEMENT: 
            case SUCCESS_ANNOUNCEMENT: 
            case NON_INTERRUPTIBLE_PLAY: 
            case SPEED: 
            case VOLUME: 
            case CLEAR_DIGIT_BUFFER: 
            case PRE_SPEECH_TIMER: 
            case POST_SPEECH_TIMER: 
            case TOTAL_RECORDING_LENGTH_TIMER: 
            case RESTART_KEY: 
            case REINPUT_KEY: 
            case RETURN_KEY: 
            case POSITION_KEY: 
            case STOP_KEY: 
            case END_INPUT_KEY: 
            case NUMBER_OF_ATTEMPTS: {
                return true;
            }
        }
        return false;
    }

    private final class AudioRecorderListener
    implements RecorderListener {
        private AudioRecorderListener() {
        }

        public void process(RecorderEvent event) {
            block0 : switch (event.getID()) {
                case 4: {
                    PlayRecord.this.context.setSpeechDetected(true);
                    break;
                }
                case 2: {
                    switch (event.getQualifier()) {
                        case 2: {
                            PlayRecord.this.fsm.fire((Object)PlayRecordEvent.NO_SPEECH, PlayRecord.this.context);
                            break block0;
                        }
                        case 1: {
                            PlayRecord.this.fsm.fire((Object)PlayRecordEvent.MAX_DURATION_EXCEEDED, PlayRecord.this.context);
                            break block0;
                        }
                    }
                    PlayRecord.this.fsm.fire((Object)PlayRecordEvent.END_RECORD, PlayRecord.this.context);
                    break;
                }
                case 3: {
                    PlayRecord.this.fsm.fire((Object)PlayRecordEvent.FAIL, PlayRecord.this.context);
                    break;
                }
            }
        }
    }

    private final class AudioPlayerListener
    implements PlayerListener {
        private AudioPlayerListener() {
        }

        public void process(PlayerEvent event) {
            switch (event.getID()) {
                case 2: {
                    PlayRecord.this.fsm.fire((Object)PlayRecordEvent.NEXT_TRACK, PlayRecord.this.context);
                    break;
                }
                case 3: {
                    PlayRecord.this.fsm.fire((Object)PlayRecordEvent.FAIL, PlayRecord.this.context);
                    break;
                }
            }
        }
    }

    private final class DetectorListener
    implements DtmfDetectorListener {
        private DetectorListener() {
        }

        public void process(DtmfEvent event) {
            char tone = event.getTone().charAt(0);
            PlayRecord.this.context.setTone(tone);
            PlayRecord.this.fsm.fire((Object)PlayRecordEvent.DTMF_TONE, PlayRecord.this.context);
        }
    }
}

