/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.transaction;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class MgcpTransactionNumberspace {
    private static final Logger log = Logger.getLogger(MgcpTransactionNumberspace.class);
    private static final int MINIMUM_ID = 1;
    private static final int MAXIMUM_ID = 999999999;
    private final int minimum;
    private final int maximum;
    private AtomicInteger current;

    public MgcpTransactionNumberspace(int minimum, int maximum) throws IllegalArgumentException {
        if (minimum < 1 || minimum > 999999999) {
            throw new IllegalArgumentException("Minimum transaction identifier " + minimum + " must be " + 1 + " <= id <= " + 999999999);
        }
        if (maximum < 1 || maximum > 999999999) {
            throw new IllegalArgumentException("Maximum transaction identifier " + maximum + " must be " + 1 + " <= id <= " + 999999999);
        }
        if (maximum < minimum) {
            throw new IllegalArgumentException("Maximum transaction identifier " + maximum + " must be greater than minimum identifier " + minimum);
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.current = new AtomicInteger(this.minimum);
    }

    public MgcpTransactionNumberspace() {
        this(1, 999999999);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getCurrent() {
        return this.current.get();
    }

    public int generateId() {
        int next = this.current.getAndIncrement();
        boolean reset = this.current.compareAndSet(this.maximum + 1, this.minimum);
        if (reset) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Reached maximum transaction identifier " + this.maximum + ". Reset number space to " + this.minimum));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Current MGCP transaction identifier is " + next));
        }
        return next;
    }
}

