/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.network;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.media.control.mgcp.message.MessageDirection;
import org.mobicents.media.control.mgcp.message.MgcpMessage;
import org.mobicents.media.control.mgcp.message.MgcpMessageObserver;
import org.mobicents.media.control.mgcp.message.MgcpMessageSubject;
import org.mobicents.media.control.mgcp.network.MgcpPacketHandler;
import org.mobicents.media.server.io.network.channel.MultiplexedNetworkChannel;
import org.mobicents.media.server.io.network.channel.NetworkGuard;
import org.mobicents.media.server.io.network.channel.PacketHandler;

public class MgcpChannel
extends MultiplexedNetworkChannel
implements MgcpMessageSubject,
MgcpMessageObserver {
    private static final Logger log = Logger.getLogger(MgcpChannel.class);
    private final MgcpPacketHandler mgcpHandler;
    private final Set<MgcpMessageObserver> observers;

    public MgcpChannel(NetworkGuard networkGuard, MgcpPacketHandler packetHandler) {
        super(networkGuard, new PacketHandler[]{packetHandler});
        this.mgcpHandler = packetHandler;
        this.mgcpHandler.observe(this);
        this.observers = Sets.newConcurrentHashSet();
    }

    protected Logger log() {
        return log;
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unregistered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }

    @Override
    public void onMessage(InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        this.notify(this, from, to, message, direction);
    }

    public void send(InetSocketAddress to, MgcpMessage message) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Outgoing MGCP message to " + to.toString() + ":\n\n" + message.toString() + "\n"));
        }
        byte[] data = message.toString().getBytes();
        this.send(data, to);
    }
}

