/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.control.mgcp.pkg.r;

import org.mobicents.media.control.mgcp.exception.AbstractSubMgcpEventProvider;
import org.mobicents.media.control.mgcp.exception.MalformedMgcpEventRequestException;
import org.mobicents.media.control.mgcp.exception.MgcpParseException;
import org.mobicents.media.control.mgcp.pkg.MgcpEvent;
import org.mobicents.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.mobicents.media.control.mgcp.pkg.r.RtpEventType;
import org.mobicents.media.control.mgcp.pkg.r.RtpPackage;
import org.mobicents.media.control.mgcp.pkg.r.rto.RtpTimeoutEventParser;

public class RtpEventProvider
extends AbstractSubMgcpEventProvider {
    public RtpEventProvider(RtpPackage pkg) {
        super(pkg);
    }

    @Override
    protected MgcpEvent parse(MgcpRequestedEvent requestedEvent) throws MalformedMgcpEventRequestException {
        RtpEventType eventType = RtpEventType.fromSymbol(requestedEvent.getEventType());
        if (eventType != null) {
            switch (eventType) {
                case RTP_TIMEOUT: {
                    try {
                        return RtpTimeoutEventParser.parse(requestedEvent.getConnectionId(), requestedEvent.getParameters());
                    }
                    catch (MgcpParseException e) {
                        throw new MalformedMgcpEventRequestException("Could not parse " + requestedEvent.toString() + "event request.", e);
                    }
                }
            }
            throw new MalformedMgcpEventRequestException("Unsupported event type " + requestedEvent.toString());
        }
        throw new MalformedMgcpEventRequestException("Unrecognizable event type " + requestedEvent.toString());
    }
}

