/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.media.Component;
import org.mobicents.media.ComponentFactory;
import org.mobicents.media.ComponentType;
import org.mobicents.media.core.connections.LocalConnectionImpl;
import org.mobicents.media.core.connections.RtpConnectionImpl;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.impl.resource.audio.AudioRecorderImpl;
import org.mobicents.media.server.impl.resource.dtmf.DetectorImpl;
import org.mobicents.media.server.impl.resource.dtmf.GeneratorImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.AudioPlayerImpl;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalDetector;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalGenerator;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.dsp.DspFactory;

public class ResourcesPool
implements ComponentFactory {
    private static final Logger logger = Logger.getLogger(ResourcesPool.class);
    private final PriorityQueueScheduler scheduler;
    private final ChannelsManager channelsManager;
    private final DspFactory dspFactory;
    private final ConcurrentCyclicFIFO<Component> players;
    private final ConcurrentCyclicFIFO<Component> recorders;
    private final ConcurrentCyclicFIFO<Component> dtmfDetectors;
    private final ConcurrentCyclicFIFO<Component> dtmfGenerators;
    private final ConcurrentCyclicFIFO<Component> signalDetectors;
    private final ConcurrentCyclicFIFO<Component> signalGenerators;
    private int defaultPlayers;
    private int defaultRecorders;
    private int defaultDtmfDetectors;
    private int defaultDtmfGenerators;
    private int defaultSignalDetectors;
    private int defaultSignalGenerators;
    private int dtmfDetectorDbi;
    private AtomicInteger playersCount;
    private AtomicInteger recordersCount;
    private AtomicInteger dtmfDetectorsCount;
    private AtomicInteger dtmfGeneratorsCount;
    private AtomicInteger signalDetectorsCount;
    private AtomicInteger signalGeneratorsCount;
    private final ConcurrentCyclicFIFO<Connection> localConnections;
    private final ConcurrentCyclicFIFO<Connection> remoteConnections;
    private int defaultLocalConnections;
    private int defaultRemoteConnections;
    private AtomicInteger connectionId;
    private AtomicInteger localConnectionsCount;
    private AtomicInteger rtpConnectionsCount;

    public ResourcesPool(PriorityQueueScheduler scheduler, ChannelsManager channelsManager, DspFactory dspFactory) {
        this.scheduler = scheduler;
        this.channelsManager = channelsManager;
        this.dspFactory = dspFactory;
        this.players = new ConcurrentCyclicFIFO();
        this.recorders = new ConcurrentCyclicFIFO();
        this.dtmfDetectors = new ConcurrentCyclicFIFO();
        this.dtmfGenerators = new ConcurrentCyclicFIFO();
        this.signalDetectors = new ConcurrentCyclicFIFO();
        this.signalGenerators = new ConcurrentCyclicFIFO();
        this.localConnections = new ConcurrentCyclicFIFO();
        this.remoteConnections = new ConcurrentCyclicFIFO();
        this.dtmfDetectorDbi = -35;
        this.connectionId = new AtomicInteger(1);
        this.localConnectionsCount = new AtomicInteger(0);
        this.rtpConnectionsCount = new AtomicInteger(0);
        this.playersCount = new AtomicInteger(0);
        this.recordersCount = new AtomicInteger(0);
        this.dtmfDetectorsCount = new AtomicInteger(0);
        this.dtmfGeneratorsCount = new AtomicInteger(0);
        this.signalDetectorsCount = new AtomicInteger(0);
        this.signalGeneratorsCount = new AtomicInteger(0);
    }

    public DspFactory getDspFactory() {
        return this.dspFactory;
    }

    public void setDefaultPlayers(int value) {
        this.defaultPlayers = value;
    }

    public void setDefaultRecorders(int value) {
        this.defaultRecorders = value;
    }

    public void setDefaultDtmfDetectors(int value) {
        this.defaultDtmfDetectors = value;
    }

    public void setDefaultDtmfGenerators(int value) {
        this.defaultDtmfGenerators = value;
    }

    public void setDefaultSignalDetectors(int value) {
        this.defaultSignalDetectors = value;
    }

    public void setDefaultSignalGenerators(int value) {
        this.defaultSignalGenerators = value;
    }

    public void setDefaultLocalConnections(int value) {
        this.defaultLocalConnections = value;
    }

    public void setDefaultRemoteConnections(int value) {
        this.defaultRemoteConnections = value;
    }

    public void setDtmfDetectorDbi(int value) {
        this.dtmfDetectorDbi = value;
    }

    public void start() {
        int i;
        for (i = 0; i < this.defaultPlayers; ++i) {
            AudioPlayerImpl player = new AudioPlayerImpl("player", this.scheduler);
            try {
                player.setDsp(this.dspFactory.newProcessor());
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.players.offer((Object)player);
        }
        this.playersCount.set(this.defaultPlayers);
        for (i = 0; i < this.defaultRecorders; ++i) {
            this.recorders.offer((Object)new AudioRecorderImpl(this.scheduler));
        }
        this.recordersCount.set(this.defaultRecorders);
        for (i = 0; i < this.defaultDtmfDetectors; ++i) {
            DetectorImpl detector = new DetectorImpl("detector", this.scheduler);
            detector.setVolume(this.dtmfDetectorDbi);
            this.dtmfDetectors.offer((Object)detector);
        }
        this.dtmfDetectorsCount.set(this.defaultDtmfDetectors);
        for (i = 0; i < this.defaultDtmfGenerators; ++i) {
            GeneratorImpl generator = new GeneratorImpl("generator", this.scheduler);
            generator.setToneDuration(100);
            generator.setVolume(-20);
            this.dtmfGenerators.offer((Object)generator);
        }
        this.dtmfGeneratorsCount.set(this.defaultDtmfGenerators);
        for (i = 0; i < this.defaultSignalDetectors; ++i) {
            this.signalDetectors.offer((Object)new PhoneSignalDetector("signal detector", this.scheduler));
        }
        this.signalDetectorsCount.set(this.defaultSignalDetectors);
        for (i = 0; i < this.defaultSignalGenerators; ++i) {
            this.signalGenerators.offer((Object)new PhoneSignalGenerator("signal generator", this.scheduler));
        }
        this.signalGeneratorsCount.set(this.defaultSignalGenerators);
        for (i = 0; i < this.defaultLocalConnections; ++i) {
            this.localConnections.offer((Object)new LocalConnectionImpl(this.connectionId.incrementAndGet(), this.channelsManager));
        }
        this.localConnectionsCount.set(this.defaultLocalConnections);
        for (i = 0; i < this.defaultRemoteConnections; ++i) {
            this.remoteConnections.offer((Object)new RtpConnectionImpl(this.connectionId.incrementAndGet(), this.channelsManager, this.dspFactory));
        }
        this.rtpConnectionsCount.set(this.defaultRemoteConnections);
    }

    public Component newAudioComponent(ComponentType componentType) {
        Component result = null;
        switch (componentType) {
            case DTMF_DETECTOR: {
                result = (Component)this.dtmfDetectors.poll();
                if (result == null) {
                    result = new DetectorImpl("detector", this.scheduler);
                    ((DetectorImpl)result).setVolume(this.dtmfDetectorDbi);
                    this.dtmfDetectorsCount.incrementAndGet();
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated new dtmf detector, pool size:" + this.dtmfDetectorsCount.get() + ", free:" + this.dtmfDetectors.size()));
                break;
            }
            case DTMF_GENERATOR: {
                result = (Component)this.dtmfGenerators.poll();
                if (result == null) {
                    result = new GeneratorImpl("generator", this.scheduler);
                    ((GeneratorImpl)result).setToneDuration(80);
                    ((GeneratorImpl)result).setVolume(-20);
                    this.dtmfGeneratorsCount.incrementAndGet();
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated new dtmf generator, pool size:" + this.dtmfGeneratorsCount.get() + ", free:" + this.dtmfDetectors.size()));
                break;
            }
            case PLAYER: {
                result = (Component)this.players.poll();
                if (result == null) {
                    result = new AudioPlayerImpl("player", this.scheduler);
                    try {
                        ((AudioPlayerImpl)result).setDsp(this.dspFactory.newProcessor());
                    }
                    catch (Exception ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    this.playersCount.incrementAndGet();
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated new player, pool size:" + this.playersCount.get() + ", free:" + this.players.size()));
                break;
            }
            case RECORDER: {
                result = (Component)this.recorders.poll();
                if (result == null) {
                    result = new AudioRecorderImpl(this.scheduler);
                    this.recordersCount.incrementAndGet();
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated new recorder, pool size:" + this.recordersCount.get() + ", free:" + this.recorders.size()));
                break;
            }
            case SIGNAL_DETECTOR: {
                result = (Component)this.signalDetectors.poll();
                if (result == null) {
                    result = new PhoneSignalDetector("signal detector", this.scheduler);
                    this.signalDetectorsCount.incrementAndGet();
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated new signal detector, pool size:" + this.signalDetectorsCount.get() + ", free:" + this.signalDetectors.size()));
                break;
            }
            case SIGNAL_GENERATOR: {
                result = (Component)this.signalGenerators.poll();
                if (result == null) {
                    result = new PhoneSignalGenerator("signal generator", this.scheduler);
                    this.signalGeneratorsCount.incrementAndGet();
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated new signal generator, pool size:" + this.signalGeneratorsCount.get() + ", free:" + this.signalGenerators.size()));
                break;
            }
        }
        return result;
    }

    public void releaseAudioComponent(Component component, ComponentType componentType) {
        switch (componentType) {
            case DTMF_DETECTOR: {
                this.dtmfDetectors.offer((Object)component);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released dtmf detector,pool size:" + this.dtmfDetectorsCount.get() + ",free:" + this.dtmfDetectors.size()));
                break;
            }
            case DTMF_GENERATOR: {
                this.dtmfGenerators.offer((Object)component);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released dtmf generator,pool size:" + this.dtmfGeneratorsCount.get() + ",free:" + this.dtmfGenerators.size()));
                break;
            }
            case PLAYER: {
                this.players.offer((Object)component);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released player,pool size:" + this.playersCount.get() + ",free:" + this.players.size()));
                break;
            }
            case RECORDER: {
                this.recorders.offer((Object)component);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released recorder,pool size:" + this.recordersCount.get() + ",free:" + this.recorders.size()));
                break;
            }
            case SIGNAL_DETECTOR: {
                this.signalDetectors.offer((Object)component);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released signal detector,pool size:" + this.signalDetectorsCount.get() + ",free:" + this.signalDetectors.size()));
                break;
            }
            case SIGNAL_GENERATOR: {
                this.signalGenerators.offer((Object)component);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released signal generator,pool size:" + this.signalGeneratorsCount.get() + ",free:" + this.signalGenerators.size()));
                break;
            }
        }
    }

    public Connection newConnection(boolean isLocal) {
        Connection result = null;
        if (isLocal) {
            result = (Connection)this.localConnections.poll();
            if (result == null) {
                result = new LocalConnectionImpl(this.connectionId.incrementAndGet(), this.channelsManager);
                this.localConnectionsCount.incrementAndGet();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Allocated new local connection, pool size:" + this.localConnectionsCount.get() + ",free:" + this.localConnections.size()));
            }
        } else {
            result = (Connection)this.remoteConnections.poll();
            if (result == null) {
                result = new RtpConnectionImpl(this.connectionId.incrementAndGet(), this.channelsManager, this.dspFactory);
                this.rtpConnectionsCount.incrementAndGet();
            } else {
                result.generateCname();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Allocated new rtp connection " + result.getCname() + ", pool size:" + this.rtpConnectionsCount.get() + ", free:" + this.remoteConnections.size()));
            }
        }
        return result;
    }

    public void releaseConnection(Connection connection, boolean isLocal) {
        if (isLocal) {
            this.localConnections.offer((Object)connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released local connection,pool size:" + this.localConnectionsCount.get() + ",free:" + this.localConnections.size()));
            }
        } else {
            this.remoteConnections.offer((Object)connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released rtp connection,pool size:" + this.rtpConnectionsCount.get() + ",free:" + this.remoteConnections.size()));
            }
        }
    }
}

