/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.endpoints;

import java.util.concurrent.Semaphore;
import org.mobicents.media.Component;
import org.mobicents.media.ComponentType;
import org.mobicents.media.core.ResourcesPool;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.resource.audio.AudioRecorderImpl;
import org.mobicents.media.server.impl.resource.dtmf.DetectorImpl;
import org.mobicents.media.server.impl.resource.dtmf.GeneratorImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.AudioPlayerImpl;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalDetector;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalGenerator;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.Endpoint;

public class MediaGroup {
    private Component player;
    private Component recorder;
    private Component dtmfDetector;
    private Component dtmfGenerator;
    private Component signalDetector;
    private Component signalGenerator;
    private ResourcesPool resourcesPool;
    private AudioComponent audioComponent;
    private OOBComponent oobComponent;
    private Endpoint endpoint;
    private int readComponents = 0;
    private int writeComponents = 0;
    private int readDtmfComponents = 0;
    private int writeDtmfComponents = 0;
    private Semaphore resourceSemaphore = new Semaphore(1);

    public MediaGroup(ResourcesPool resourcesPool, Endpoint endpoint) {
        this.resourcesPool = resourcesPool;
        this.audioComponent = new AudioComponent(0);
        this.oobComponent = new OOBComponent(0);
        this.endpoint = endpoint;
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBComponent getOOBComponent() {
        return this.oobComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getPlayer() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.player == null) {
                this.player = this.resourcesPool.newAudioComponent(ComponentType.PLAYER);
                this.player.setEndpoint(this.endpoint);
                this.audioComponent.addInput(((AudioPlayerImpl)this.player).getAudioInput());
                ++this.readComponents;
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(this.writeComponents != 0));
                this.updateEndpoint(1, 0);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePlayer() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.player != null) {
                this.audioComponent.remove(((AudioPlayerImpl)this.player).getAudioInput());
                --this.readComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(this.writeComponents != 0));
                this.updateEndpoint(-1, 0);
                this.player.clearEndpoint();
                ((AudioPlayerImpl)this.player).clearAllListeners();
                this.player.deactivate();
                this.resourcesPool.releaseAudioComponent(this.player, ComponentType.PLAYER);
                this.player = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getRecorder() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.recorder == null) {
                this.recorder = this.resourcesPool.newAudioComponent(ComponentType.RECORDER);
                this.recorder.setEndpoint(this.endpoint);
                this.audioComponent.addOutput(((AudioRecorderImpl)this.recorder).getAudioOutput());
                this.oobComponent.addOutput(((AudioRecorderImpl)this.recorder).getOOBOutput());
                ++this.writeComponents;
                ++this.writeDtmfComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(this.readDtmfComponents != 0), Boolean.valueOf(true));
                this.updateEndpoint(0, 1);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRecorder() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.recorder != null) {
                this.audioComponent.remove(((AudioRecorderImpl)this.recorder).getAudioOutput());
                this.oobComponent.remove(((AudioRecorderImpl)this.recorder).getOOBOutput());
                --this.writeComponents;
                --this.writeDtmfComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(this.writeComponents != 0));
                this.oobComponent.updateMode(Boolean.valueOf(this.readDtmfComponents != 0), Boolean.valueOf(this.writeDtmfComponents != 0));
                this.updateEndpoint(0, -1);
                this.recorder.clearEndpoint();
                ((AudioRecorderImpl)this.recorder).clearAllListeners();
                this.recorder.deactivate();
                this.resourcesPool.releaseAudioComponent(this.recorder, ComponentType.RECORDER);
                this.recorder = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasRecorder() {
        return this.recorder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getDtmfDetector() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfDetector == null) {
                this.dtmfDetector = this.resourcesPool.newAudioComponent(ComponentType.DTMF_DETECTOR);
                this.dtmfDetector.setEndpoint(this.endpoint);
                this.audioComponent.addOutput(((DetectorImpl)this.dtmfDetector).getAudioOutput());
                this.oobComponent.addOutput(((DetectorImpl)this.dtmfDetector).getOOBOutput());
                ++this.writeComponents;
                ++this.writeDtmfComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(this.readDtmfComponents != 0), Boolean.valueOf(true));
                this.updateEndpoint(0, 1);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.dtmfDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDtmfDetector() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfDetector != null) {
                this.audioComponent.remove(((DetectorImpl)this.dtmfDetector).getAudioOutput());
                this.oobComponent.remove(((DetectorImpl)this.dtmfDetector).getOOBOutput());
                --this.writeComponents;
                --this.writeDtmfComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(this.writeComponents != 0));
                this.oobComponent.updateMode(Boolean.valueOf(this.readDtmfComponents != 0), Boolean.valueOf(this.writeDtmfComponents != 0));
                this.updateEndpoint(0, -1);
                this.dtmfDetector.clearEndpoint();
                ((DetectorImpl)this.dtmfDetector).clearAllListeners();
                this.dtmfDetector.deactivate();
                ((DetectorImpl)this.dtmfDetector).clearBuffer();
                this.resourcesPool.releaseAudioComponent(this.dtmfDetector, ComponentType.DTMF_DETECTOR);
                this.dtmfDetector = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasDtmfDetector() {
        return this.dtmfDetector != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getDtmfGenerator() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfGenerator == null) {
                this.dtmfGenerator = this.resourcesPool.newAudioComponent(ComponentType.DTMF_GENERATOR);
                this.dtmfGenerator.setEndpoint(this.endpoint);
                this.audioComponent.addInput(((GeneratorImpl)this.dtmfGenerator).getAudioInput());
                this.oobComponent.addInput(((GeneratorImpl)this.dtmfGenerator).getOOBInput());
                ++this.readComponents;
                ++this.readDtmfComponents;
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(this.writeComponents != 0));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(this.writeDtmfComponents != 0));
                this.updateEndpoint(1, 0);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.dtmfGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDtmfGenerator() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dtmfGenerator != null) {
                this.audioComponent.remove(((GeneratorImpl)this.dtmfGenerator).getAudioInput());
                this.oobComponent.remove(((GeneratorImpl)this.dtmfGenerator).getOOBInput());
                --this.readComponents;
                --this.readDtmfComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(this.writeComponents != 0));
                this.oobComponent.updateMode(Boolean.valueOf(this.readDtmfComponents != 0), Boolean.valueOf(this.writeDtmfComponents != 0));
                this.updateEndpoint(-1, 0);
                this.dtmfGenerator.clearEndpoint();
                this.dtmfGenerator.deactivate();
                this.resourcesPool.releaseAudioComponent(this.dtmfGenerator, ComponentType.DTMF_GENERATOR);
                this.dtmfGenerator = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasDtmfGenerator() {
        return this.dtmfGenerator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getSignalDetector() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.signalDetector == null) {
                this.signalDetector = this.resourcesPool.newAudioComponent(ComponentType.SIGNAL_DETECTOR);
                this.signalDetector.setEndpoint(this.endpoint);
                this.audioComponent.addOutput(((PhoneSignalDetector)this.signalDetector).getAudioOutput());
                ++this.writeComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(true));
                this.updateEndpoint(0, 1);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.signalDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSignalDetector() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.signalDetector != null) {
                this.audioComponent.remove(((PhoneSignalDetector)this.signalDetector).getAudioOutput());
                --this.writeComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(this.writeComponents != 0));
                this.updateEndpoint(0, -1);
                this.signalDetector.clearEndpoint();
                ((PhoneSignalDetector)this.signalDetector).clearAllListeners();
                this.signalDetector.deactivate();
                this.resourcesPool.releaseAudioComponent(this.signalDetector, ComponentType.SIGNAL_DETECTOR);
                this.signalDetector.deactivate();
                this.signalDetector = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasSignalDetector() {
        return this.signalDetector != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getSignalGenerator() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.signalGenerator == null) {
                this.signalGenerator = this.resourcesPool.newAudioComponent(ComponentType.SIGNAL_GENERATOR);
                this.signalGenerator.setEndpoint(this.endpoint);
                this.audioComponent.addInput(((PhoneSignalGenerator)this.signalGenerator).getAudioInput());
                ++this.readComponents;
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(this.writeComponents != 0));
                this.updateEndpoint(1, 0);
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
        return this.signalGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSignalGenerator() {
        try {
            this.resourceSemaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.signalGenerator != null) {
                this.audioComponent.remove(((PhoneSignalGenerator)this.signalGenerator).getAudioInput());
                --this.readComponents;
                this.audioComponent.updateMode(Boolean.valueOf(this.readComponents != 0), Boolean.valueOf(this.writeComponents != 0));
                this.updateEndpoint(-1, 0);
                this.signalGenerator.clearEndpoint();
                this.signalGenerator.deactivate();
                this.resourcesPool.releaseAudioComponent(this.signalGenerator, ComponentType.SIGNAL_GENERATOR);
                this.signalGenerator = null;
            }
        }
        finally {
            this.resourceSemaphore.release();
        }
    }

    public boolean hasSignalGenerator() {
        return this.signalGenerator != null;
    }

    private void updateEndpoint(int readChange, int writeChange) {
        boolean newWrite;
        boolean oldRead = this.readComponents - readChange != 0;
        boolean oldWrite = this.writeComponents - writeChange != 0;
        boolean newRead = this.readComponents != 0;
        boolean bl = newWrite = this.writeComponents != 0;
        if (newRead == oldRead && newWrite == oldWrite) {
            return;
        }
        ConnectionMode oldMode = oldRead ? (oldWrite ? ConnectionMode.CONFERENCE : ConnectionMode.RECV_ONLY) : (oldWrite ? ConnectionMode.SEND_ONLY : ConnectionMode.INACTIVE);
        ConnectionMode newMode = newRead ? (newWrite ? ConnectionMode.CONFERENCE : ConnectionMode.RECV_ONLY) : (newWrite ? ConnectionMode.SEND_ONLY : ConnectionMode.INACTIVE);
        this.endpoint.modeUpdated(oldMode, newMode);
    }

    public void releaseAll() {
        this.releasePlayer();
        this.releaseRecorder();
        this.releaseDtmfDetector();
        this.releaseDtmfGenerator();
        this.releaseSignalDetector();
        this.releaseSignalGenerator();
    }
}

