/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.pooling;

import java.util.Queue;
import org.mobicents.media.core.pooling.PooledObject;
import org.mobicents.media.core.pooling.ResourcePool;

public abstract class AbstractResourcePool<T extends PooledObject>
implements ResourcePool<T> {
    private final Queue<T> resources;

    protected AbstractResourcePool(Queue<T> resources, int initialCapacity) {
        this.resources = resources;
        for (int index = 0; index < initialCapacity; ++index) {
            this.resources.offer(this.createResource());
        }
    }

    @Override
    public T poll() {
        PooledObject resource = (PooledObject)this.resources.poll();
        if (resource == null) {
            resource = this.createResource();
        }
        resource.checkOut();
        return (T)resource;
    }

    @Override
    public void offer(T resource) {
        if (resource != null) {
            resource.checkIn();
            this.resources.offer(resource);
        }
    }

    @Override
    public void release() {
        this.resources.clear();
    }

    @Override
    public int count() {
        return this.resources.size();
    }

    @Override
    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    protected abstract T createResource();
}

