/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core;

import org.apache.log4j.Logger;
import org.mobicents.media.Component;
import org.mobicents.media.ComponentFactory;
import org.mobicents.media.ComponentType;
import org.mobicents.media.core.connections.LocalConnectionImpl;
import org.mobicents.media.core.connections.LocalConnectionPool;
import org.mobicents.media.core.connections.RtpConnectionImpl;
import org.mobicents.media.core.connections.RtpConnectionPool;
import org.mobicents.media.server.impl.resource.audio.AudioRecorderImpl;
import org.mobicents.media.server.impl.resource.audio.AudioRecorderPool;
import org.mobicents.media.server.impl.resource.dtmf.DetectorImpl;
import org.mobicents.media.server.impl.resource.dtmf.DtmfDetectorPool;
import org.mobicents.media.server.impl.resource.dtmf.DtmfGeneratorPool;
import org.mobicents.media.server.impl.resource.dtmf.GeneratorImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.AudioPlayerImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.AudioPlayerPool;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalDetector;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalDetectorPool;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalGenerator;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalGeneratorPool;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.pooling.PooledObject;
import org.mobicents.media.server.spi.pooling.ResourcePool;

public class ResourcesPool
implements ComponentFactory {
    private static final Logger logger = Logger.getLogger(ResourcesPool.class);
    private final ResourcePool<AudioPlayerImpl> players;
    private final ResourcePool<AudioRecorderImpl> recorders;
    private final ResourcePool<DetectorImpl> dtmfDetectors;
    private final ResourcePool<GeneratorImpl> dtmfGenerators;
    private final ResourcePool<PhoneSignalDetector> signalDetectors;
    private final ResourcePool<PhoneSignalGenerator> signalGenerators;
    private final ResourcePool<LocalConnectionImpl> localConnections;
    private final ResourcePool<RtpConnectionImpl> remoteConnections;

    public ResourcesPool(RtpConnectionPool rtpConnections, LocalConnectionPool localConnections, AudioPlayerPool players, AudioRecorderPool recorders, DtmfDetectorPool dtmfDetectors, DtmfGeneratorPool dtmfGenerators, PhoneSignalDetectorPool signalDetectors, PhoneSignalGeneratorPool signalGenerators) {
        this.players = players;
        this.recorders = recorders;
        this.dtmfDetectors = dtmfDetectors;
        this.dtmfGenerators = dtmfGenerators;
        this.signalDetectors = signalDetectors;
        this.signalGenerators = signalGenerators;
        this.localConnections = localConnections;
        this.remoteConnections = rtpConnections;
    }

    public Component newAudioComponent(ComponentType componentType) {
        Component result = null;
        switch (componentType) {
            case DTMF_DETECTOR: {
                result = (Component)this.dtmfDetectors.poll();
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated DTMF Detector [pool size:" + this.dtmfDetectors.size() + ", free:" + this.dtmfDetectors.count() + "]"));
                break;
            }
            case DTMF_GENERATOR: {
                result = (Component)this.dtmfGenerators.poll();
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated DTMF Generator [pool size:" + this.dtmfGenerators.size() + ", free:" + this.dtmfDetectors.count() + "]"));
                break;
            }
            case PLAYER: {
                result = (Component)this.players.poll();
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated Player [pool size:" + this.players.size() + ", free:" + this.players.count() + "]"));
                break;
            }
            case RECORDER: {
                result = (Component)this.recorders.poll();
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated Recorder [pool size:" + this.recorders.size() + ", free:" + this.recorders.count() + "]"));
                break;
            }
            case SIGNAL_DETECTOR: {
                result = (Component)this.signalDetectors.poll();
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated Signal Detector [pool size:" + this.signalDetectors.size() + ", free:" + this.signalDetectors.count() + "]"));
                break;
            }
            case SIGNAL_GENERATOR: {
                result = (Component)this.signalGenerators.poll();
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Allocated Signal Generator [pool size:" + this.signalGenerators.size() + ", free:" + this.signalGenerators.count() + "]"));
                break;
            }
        }
        return result;
    }

    public void releaseAudioComponent(Component component, ComponentType componentType) {
        switch (componentType) {
            case DTMF_DETECTOR: {
                this.dtmfDetectors.offer((PooledObject)((DetectorImpl)component));
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released DTMF Detector [pool size:" + this.dtmfDetectors.size() + ", free:" + this.dtmfDetectors.size() + "]"));
                break;
            }
            case DTMF_GENERATOR: {
                this.dtmfGenerators.offer((PooledObject)((GeneratorImpl)component));
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released DTMF Generator [pool size:" + this.dtmfGenerators.size() + ",free:" + this.dtmfGenerators.count() + "]"));
                break;
            }
            case PLAYER: {
                this.players.offer((PooledObject)((AudioPlayerImpl)component));
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released Player [pool size:" + this.players.size() + ", free:" + this.players.count() + "]"));
                break;
            }
            case RECORDER: {
                this.recorders.offer((PooledObject)((AudioRecorderImpl)component));
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released Recorder [pool size:" + this.recorders.size() + ", free:" + this.recorders.count() + "]"));
                break;
            }
            case SIGNAL_DETECTOR: {
                this.signalDetectors.offer((PooledObject)((PhoneSignalDetector)component));
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released Signal Detector [pool size:" + this.signalDetectors.size() + ", free:" + this.signalDetectors.count() + "]"));
                break;
            }
            case SIGNAL_GENERATOR: {
                this.signalGenerators.offer((PooledObject)((PhoneSignalGenerator)component));
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Released Signal Generator [pool size:" + this.signalGenerators.size() + ", free:" + this.signalGenerators.count() + "]"));
                break;
            }
        }
    }

    public Connection newConnection(boolean isLocal) {
        Connection result = null;
        if (isLocal) {
            result = (Connection)this.localConnections.poll();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Allocated local connection [pool size:" + this.localConnections.size() + ", free:" + this.localConnections.count() + "]"));
            }
        } else {
            result = (Connection)this.remoteConnections.poll();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Allocated remote connection [pool size:" + this.remoteConnections.size() + ", free:" + this.remoteConnections.count() + "]"));
            }
        }
        return result;
    }

    public void releaseConnection(Connection connection, boolean isLocal) {
        if (isLocal) {
            this.localConnections.offer((PooledObject)((LocalConnectionImpl)connection));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released local connection [pool size:" + this.localConnections.size() + ", free:" + this.localConnections.count() + "]"));
            }
        } else {
            this.remoteConnections.offer((PooledObject)((RtpConnectionImpl)connection));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released remote connection [pool size:" + this.remoteConnections.size() + ", free:" + this.remoteConnections.count() + "]"));
            }
        }
    }
}

