/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.media.core.ResourcesPool;
import org.mobicents.media.core.endpoints.BaseEndpointImpl;
import org.mobicents.media.core.endpoints.VirtualEndpointInstaller;
import org.mobicents.media.core.naming.NamingService;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointInstaller;
import org.mobicents.media.server.spi.MediaServer;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.ServerManager;

public class Server
implements MediaServer {
    private Clock clock;
    private PriorityQueueScheduler scheduler;
    private ResourcesPool resourcesPool;
    private UdpManager udpManager;
    private final NamingService namingService;
    private final ArrayList<EndpointInstaller> installers = new ArrayList();
    private final Map<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();
    private final ArrayList<ServerManager> managers = new ArrayList();
    private HeartBeat heartbeat;
    private int heartbeatTime = 0;
    private volatile long ttl;
    private static final Logger logger = Logger.getLogger(Server.class);

    public Server() {
        this.namingService = new NamingService();
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setScheduler(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setUdpManager(UdpManager udpManager) {
        this.udpManager = udpManager;
    }

    public void setResourcesPool(ResourcesPool resourcesPool) {
        this.resourcesPool = resourcesPool;
    }

    public void setHeartBeatTime(int heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public void addInstaller(EndpointInstaller installer) {
        ((VirtualEndpointInstaller)installer).setServer(this);
        this.installers.add(installer);
        installer.install();
    }

    public void removeInstaller(EndpointInstaller installer) {
        this.installers.remove(installer);
        installer.uninstall();
    }

    public void install(Endpoint endpoint, EndpointInstaller installer) {
        if (endpoint == null) {
            logger.error((Object)"Unknown endpoint");
            return;
        }
        BaseEndpointImpl baseEndpoint = null;
        try {
            baseEndpoint = (BaseEndpointImpl)endpoint;
        }
        catch (ClassCastException e) {
            logger.error((Object)("Unsupported endpoint implementation " + endpoint.getLocalName()));
            return;
        }
        baseEndpoint.setScheduler(this.scheduler);
        baseEndpoint.setResourcesPool(this.resourcesPool);
        logger.info((Object)("Installing " + endpoint.getLocalName()));
        try {
            endpoint.start();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't start endpoint " + endpoint.getLocalName()), (Throwable)e);
            return;
        }
        try {
            this.namingService.register(endpoint);
        }
        catch (Exception e) {
            endpoint.stop();
            logger.error((Object)("Could not register endpoint " + endpoint.getLocalName()), (Throwable)e);
        }
        this.endpoints.put(endpoint.getLocalName(), endpoint);
        for (ServerManager manager : this.managers) {
            manager.onStarted(endpoint, installer);
        }
    }

    public void uninstalls(String name) {
        Endpoint endpoint = this.endpoints.remove(name);
        for (ServerManager manager : this.managers) {
            manager.onStopped(endpoint);
        }
        try {
            endpoint = this.namingService.lookup(name, true);
            if (endpoint != null) {
                endpoint.stop();
                this.namingService.unregister(endpoint);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void start() throws Exception {
        if (this.clock == null) {
            logger.error((Object)"Timing clock is not defined");
            return;
        }
        if (this.heartbeatTime > 0) {
            this.heartbeat = new HeartBeat();
            this.heartbeat.restart();
        }
    }

    public void stop() {
        logger.info((Object)"Stopping UDP Manager");
        this.udpManager.stop();
        if (this.heartbeat != null) {
            this.heartbeat.cancel();
        }
        logger.info((Object)"Stopping scheduler");
        this.scheduler.stop();
        logger.info((Object)"Stopped media server instance ");
    }

    public Endpoint lookup(String name, boolean bussy) throws ResourceUnavailableException {
        return null;
    }

    public Endpoint[] lookupall(String endpointName) throws ResourceUnavailableException {
        return null;
    }

    public int getEndpointCount() {
        return 0;
    }

    public Collection<Endpoint> getEndpoints() {
        return this.endpoints.values();
    }

    public void addManager(ServerManager manager) {
        this.managers.add(manager);
    }

    public void removeManager(ServerManager manager) {
        this.managers.remove(manager);
    }

    private class HeartBeat
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.HEARTBEAT_QUEUE;
        }

        public void restart() {
            Server.this.ttl = Server.this.heartbeatTime * 600;
            Server.this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            Server.this.ttl--;
            if (Server.this.ttl == 0L) {
                logger.info((Object)"Global hearbeat is still alive");
                this.restart();
            } else {
                Server.this.scheduler.submitHeatbeat((Task)this);
            }
            return 0L;
        }
    }
}

