/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.endpoints;

import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.core.connections.BaseConnection;
import org.mobicents.media.core.endpoints.BaseEndpointImpl;
import org.mobicents.media.server.component.audio.AudioSplitter;
import org.mobicents.media.server.component.oob.OOBSplitter;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class BaseSplitterEndpointImpl
extends BaseEndpointImpl {
    protected AudioSplitter audioSplitter;
    protected OOBSplitter oobSplitter;
    private AtomicInteger loopbackCount = new AtomicInteger(0);
    private AtomicInteger readCount = new AtomicInteger(0);
    private AtomicInteger writeCount = new AtomicInteger(0);

    public BaseSplitterEndpointImpl(String localName) {
        super(localName);
    }

    @Override
    public void start() throws ResourceUnavailableException {
        super.start();
        this.audioSplitter = new AudioSplitter(this.getScheduler());
        this.oobSplitter = new OOBSplitter(this.getScheduler());
    }

    @Override
    public Connection createConnection(ConnectionType type, Boolean isLocal) throws ResourceUnavailableException {
        Connection connection = super.createConnection(type, isLocal);
        switch (type) {
            case RTP: {
                this.audioSplitter.addOutsideComponent(((BaseConnection)connection).getAudioComponent());
                this.oobSplitter.addOutsideComponent(((BaseConnection)connection).getOOBComponent());
                break;
            }
            case LOCAL: {
                this.audioSplitter.addInsideComponent(((BaseConnection)connection).getAudioComponent());
                this.oobSplitter.addInsideComponent(((BaseConnection)connection).getOOBComponent());
            }
        }
        return connection;
    }

    @Override
    public void deleteConnection(Connection connection, ConnectionType connectionType) {
        super.deleteConnection(connection, connectionType);
        switch (connectionType) {
            case RTP: {
                this.audioSplitter.releaseOutsideComponent(((BaseConnection)connection).getAudioComponent());
                this.oobSplitter.releaseOutsideComponent(((BaseConnection)connection).getOOBComponent());
                break;
            }
            case LOCAL: {
                this.audioSplitter.releaseInsideComponent(((BaseConnection)connection).getAudioComponent());
                this.oobSplitter.releaseInsideComponent(((BaseConnection)connection).getOOBComponent());
            }
        }
    }

    public void configure(boolean isALaw) {
    }

    public void modeUpdated(ConnectionMode oldMode, ConnectionMode newMode) {
        int readCount = 0;
        int loopbackCount = 0;
        int writeCount = 0;
        switch (oldMode) {
            case RECV_ONLY: {
                --readCount;
                break;
            }
            case SEND_ONLY: {
                --writeCount;
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                --readCount;
                --writeCount;
                break;
            }
            case NETWORK_LOOPBACK: {
                --loopbackCount;
                break;
            }
        }
        switch (newMode) {
            case RECV_ONLY: {
                ++readCount;
                break;
            }
            case SEND_ONLY: {
                ++writeCount;
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                ++readCount;
                ++writeCount;
                break;
            }
            case NETWORK_LOOPBACK: {
                ++loopbackCount;
                break;
            }
        }
        if (readCount != 0 || writeCount != 0 || loopbackCount != 0) {
            loopbackCount = this.loopbackCount.addAndGet(loopbackCount);
            readCount = this.readCount.addAndGet(readCount);
            writeCount = this.writeCount.addAndGet(writeCount);
            if (loopbackCount > 0 || readCount == 0 || writeCount == 0) {
                this.audioSplitter.stop();
                this.oobSplitter.stop();
            } else {
                this.audioSplitter.start();
                this.oobSplitter.start();
            }
        }
    }
}

